# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.phone_number import PhoneNumber


class PhoneWithType(object):

    """Implementation of the 'Phone With Type' model.

    The phone information.

    Attributes:
        phone_type (PhoneType): The phone type.
        phone_number (PhoneNumber): The phone number in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "phone_number": 'phone_number',
        "phone_type": 'phone_type'
    }

    _optionals = [
        'phone_type',
    ]

    def __init__(self,
                 phone_number=None,
                 phone_type=APIHelper.SKIP):
        """Constructor for the PhoneWithType class"""

        # Initialize members of the class
        if phone_type is not APIHelper.SKIP:
            self.phone_type = phone_type 
        self.phone_number = phone_number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        phone_number = PhoneNumber.from_dictionary(dictionary.get('phone_number')) if dictionary.get('phone_number') else None
        phone_type = dictionary.get("phone_type") if dictionary.get("phone_type") else APIHelper.SKIP
        # Return an object of this model
        return cls(phone_number,
                   phone_type)
