# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class Phone(object):

    """Implementation of the 'Phone' model.

    The phone number, in its canonical international [E.164 numbering plan
    format](https://www.itu.int/rec/T-REC-E.164/en).

    Attributes:
        country_code (str): The country calling code (CC), in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en). The combined
            length of the CC and the national number must not be greater than
            15 digits. The national number consists of a national destination
            code (NDC) and subscriber number (SN).
        national_number (str): The national number, in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en). The combined
            length of the country calling code (CC) and the national number
            must not be greater than 15 digits. The national number consists
            of a national destination code (NDC) and subscriber number (SN).
        extension_number (str): The extension number.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "country_code": 'country_code',
        "national_number": 'national_number',
        "extension_number": 'extension_number'
    }

    _optionals = [
        'extension_number',
    ]

    def __init__(self,
                 country_code=None,
                 national_number=None,
                 extension_number=APIHelper.SKIP):
        """Constructor for the Phone class"""

        # Initialize members of the class
        self.country_code = country_code 
        self.national_number = national_number 
        if extension_number is not APIHelper.SKIP:
            self.extension_number = extension_number 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else None
        national_number = dictionary.get("national_number") if dictionary.get("national_number") else None
        extension_number = dictionary.get("extension_number") if dictionary.get("extension_number") else APIHelper.SKIP
        # Return an object of this model
        return cls(country_code,
                   national_number,
                   extension_number)
