# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_payment_token import ApplePayPaymentToken
from paypalserversdk.models.card_payment_token import CardPaymentToken
from paypalserversdk.models.pay_pal_payment_token import PayPalPaymentToken
from paypalserversdk.models.venmo_payment_token import VenmoPaymentToken


class PaymentTokenResponsePaymentSource(object):

    """Implementation of the 'Payment Token Response Payment Source' model.

    The vaulted payment method details.

    Attributes:
        card (CardPaymentToken): Full representation of a Card Payment Token
            including network token.
        paypal (PayPalPaymentToken): TODO: type description here.
        venmo (VenmoPaymentToken): TODO: type description here.
        apple_pay (ApplePayPaymentToken): A resource representing a response
            for Apple Pay.
        bank (dict): Full representation of a Bank Payment Token.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "paypal": 'paypal',
        "venmo": 'venmo',
        "apple_pay": 'apple_pay',
        "bank": 'bank'
    }

    _optionals = [
        'card',
        'paypal',
        'venmo',
        'apple_pay',
        'bank',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 venmo=APIHelper.SKIP,
                 apple_pay=APIHelper.SKIP,
                 bank=APIHelper.SKIP):
        """Constructor for the PaymentTokenResponsePaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 
        if apple_pay is not APIHelper.SKIP:
            self.apple_pay = apple_pay 
        if bank is not APIHelper.SKIP:
            self.bank = bank 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = CardPaymentToken.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        paypal = PayPalPaymentToken.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        venmo = VenmoPaymentToken.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        apple_pay = ApplePayPaymentToken.from_dictionary(dictionary.get('apple_pay')) if 'apple_pay' in dictionary.keys() else APIHelper.SKIP
        bank = dictionary.get("bank") if dictionary.get("bank") else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   paypal,
                   venmo,
                   apple_pay,
                   bank)
