# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.customer_request import CustomerRequest
from paypalserversdk.models.link_description import LinkDescription
from paypalserversdk.models.payment_token_response_payment_source import PaymentTokenResponsePaymentSource


class PaymentTokenResponse(object):

    """Implementation of the 'Payment Token Response' model.

    Full representation of a saved payment token.

    Attributes:
        id (str): The PayPal-generated ID for the vault token.
        customer (CustomerRequest): Customer in merchant's or partner's system
            of records.
        payment_source (PaymentTokenResponsePaymentSource): The vaulted
            payment method details.
        links (List[LinkDescription]): An array of related [HATEOAS
            links](/api/rest/responses/#hateoas).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "customer": 'customer',
        "payment_source": 'payment_source',
        "links": 'links'
    }

    _optionals = [
        'id',
        'customer',
        'payment_source',
        'links',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 customer=APIHelper.SKIP,
                 payment_source=APIHelper.SKIP,
                 links=APIHelper.SKIP):
        """Constructor for the PaymentTokenResponse class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if customer is not APIHelper.SKIP:
            self.customer = customer 
        if payment_source is not APIHelper.SKIP:
            self.payment_source = payment_source 
        if links is not APIHelper.SKIP:
            self.links = links 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        customer = CustomerRequest.from_dictionary(dictionary.get('customer')) if 'customer' in dictionary.keys() else APIHelper.SKIP
        payment_source = PaymentTokenResponsePaymentSource.from_dictionary(dictionary.get('payment_source')) if 'payment_source' in dictionary.keys() else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   customer,
                   payment_source,
                   links)
