# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_request import ApplePayRequest
from paypalserversdk.models.bancontact_payment_request import BancontactPaymentRequest
from paypalserversdk.models.blik_payment_request import BLIKPaymentRequest
from paypalserversdk.models.card_request import CardRequest
from paypalserversdk.models.eps_payment_request import EPSPaymentRequest
from paypalserversdk.models.giropay_payment_request import GiropayPaymentRequest
from paypalserversdk.models.google_pay_request import GooglePayRequest
from paypalserversdk.models.ideal_payment_request import IDEALPaymentRequest
from paypalserversdk.models.my_bank_payment_request import MyBankPaymentRequest
from paypalserversdk.models.p_24_payment_request import P24PaymentRequest
from paypalserversdk.models.pay_pal_wallet import PayPalWallet
from paypalserversdk.models.sofort_payment_request import SofortPaymentRequest
from paypalserversdk.models.token import Token
from paypalserversdk.models.trustly_payment_request import TrustlyPaymentRequest
from paypalserversdk.models.venmo_wallet_request import VenmoWalletRequest


class PaymentSource(object):

    """Implementation of the 'Payment Source' model.

    The payment source definition.

    Attributes:
        card (CardRequest): The payment card to use to fund a payment. Can be
            a credit or debit card.<blockquote><strong>Note:</strong> Passing
            card number, cvv and expiry directly via the API requires <a
            href="https://www.pcisecuritystandards.org/pci_security/completing_
            self_assessment"> PCI SAQ D compliance</a>. <br>*PayPal offers a
            mechanism by which you do not have to take on the <strong>PCI SAQ
            D</strong> burden by using hosted fields - refer to <a
            href="https://developer.paypal.com/docs/checkout/advanced/integrate
            /">this Integration Guide</a>*.</blockquote>
        token (Token): The tokenized payment source to fund a payment.
        paypal (PayPalWallet): A resource that identifies a PayPal Wallet is
            used for payment.
        bancontact (BancontactPaymentRequest): Information needed to pay using
            Bancontact.
        blik (BLIKPaymentRequest): Information needed to pay using BLIK.
        eps (EPSPaymentRequest): Information needed to pay using eps.
        giropay (GiropayPaymentRequest): Information needed to pay using
            giropay.
        ideal (IDEALPaymentRequest): Information needed to pay using iDEAL.
        mybank (MyBankPaymentRequest): Information needed to pay using
            MyBank.
        p_24 (P24PaymentRequest): Information needed to pay using P24
            (Przelewy24).
        sofort (SofortPaymentRequest): Information needed to pay using
            Sofort.
        trustly (TrustlyPaymentRequest): Information needed to pay using
            Trustly.
        apple_pay (ApplePayRequest): Information needed to pay using
            ApplePay.
        google_pay (GooglePayRequest): Information needed to pay using Google
            Pay.
        venmo (VenmoWalletRequest): Information needed to pay using Venmo.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "token": 'token',
        "paypal": 'paypal',
        "bancontact": 'bancontact',
        "blik": 'blik',
        "eps": 'eps',
        "giropay": 'giropay',
        "ideal": 'ideal',
        "mybank": 'mybank',
        "p_24": 'p24',
        "sofort": 'sofort',
        "trustly": 'trustly',
        "apple_pay": 'apple_pay',
        "google_pay": 'google_pay',
        "venmo": 'venmo'
    }

    _optionals = [
        'card',
        'token',
        'paypal',
        'bancontact',
        'blik',
        'eps',
        'giropay',
        'ideal',
        'mybank',
        'p_24',
        'sofort',
        'trustly',
        'apple_pay',
        'google_pay',
        'venmo',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 token=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 bancontact=APIHelper.SKIP,
                 blik=APIHelper.SKIP,
                 eps=APIHelper.SKIP,
                 giropay=APIHelper.SKIP,
                 ideal=APIHelper.SKIP,
                 mybank=APIHelper.SKIP,
                 p_24=APIHelper.SKIP,
                 sofort=APIHelper.SKIP,
                 trustly=APIHelper.SKIP,
                 apple_pay=APIHelper.SKIP,
                 google_pay=APIHelper.SKIP,
                 venmo=APIHelper.SKIP):
        """Constructor for the PaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if token is not APIHelper.SKIP:
            self.token = token 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if bancontact is not APIHelper.SKIP:
            self.bancontact = bancontact 
        if blik is not APIHelper.SKIP:
            self.blik = blik 
        if eps is not APIHelper.SKIP:
            self.eps = eps 
        if giropay is not APIHelper.SKIP:
            self.giropay = giropay 
        if ideal is not APIHelper.SKIP:
            self.ideal = ideal 
        if mybank is not APIHelper.SKIP:
            self.mybank = mybank 
        if p_24 is not APIHelper.SKIP:
            self.p_24 = p_24 
        if sofort is not APIHelper.SKIP:
            self.sofort = sofort 
        if trustly is not APIHelper.SKIP:
            self.trustly = trustly 
        if apple_pay is not APIHelper.SKIP:
            self.apple_pay = apple_pay 
        if google_pay is not APIHelper.SKIP:
            self.google_pay = google_pay 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = CardRequest.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        token = Token.from_dictionary(dictionary.get('token')) if 'token' in dictionary.keys() else APIHelper.SKIP
        paypal = PayPalWallet.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        bancontact = BancontactPaymentRequest.from_dictionary(dictionary.get('bancontact')) if 'bancontact' in dictionary.keys() else APIHelper.SKIP
        blik = BLIKPaymentRequest.from_dictionary(dictionary.get('blik')) if 'blik' in dictionary.keys() else APIHelper.SKIP
        eps = EPSPaymentRequest.from_dictionary(dictionary.get('eps')) if 'eps' in dictionary.keys() else APIHelper.SKIP
        giropay = GiropayPaymentRequest.from_dictionary(dictionary.get('giropay')) if 'giropay' in dictionary.keys() else APIHelper.SKIP
        ideal = IDEALPaymentRequest.from_dictionary(dictionary.get('ideal')) if 'ideal' in dictionary.keys() else APIHelper.SKIP
        mybank = MyBankPaymentRequest.from_dictionary(dictionary.get('mybank')) if 'mybank' in dictionary.keys() else APIHelper.SKIP
        p_24 = P24PaymentRequest.from_dictionary(dictionary.get('p24')) if 'p24' in dictionary.keys() else APIHelper.SKIP
        sofort = SofortPaymentRequest.from_dictionary(dictionary.get('sofort')) if 'sofort' in dictionary.keys() else APIHelper.SKIP
        trustly = TrustlyPaymentRequest.from_dictionary(dictionary.get('trustly')) if 'trustly' in dictionary.keys() else APIHelper.SKIP
        apple_pay = ApplePayRequest.from_dictionary(dictionary.get('apple_pay')) if 'apple_pay' in dictionary.keys() else APIHelper.SKIP
        google_pay = GooglePayRequest.from_dictionary(dictionary.get('google_pay')) if 'google_pay' in dictionary.keys() else APIHelper.SKIP
        venmo = VenmoWalletRequest.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   token,
                   paypal,
                   bancontact,
                   blik,
                   eps,
                   giropay,
                   ideal,
                   mybank,
                   p_24,
                   sofort,
                   trustly,
                   apple_pay,
                   google_pay,
                   venmo)
