# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class PaymentMethodPreference(object):

    """Implementation of the 'Payment Method Preference' model.

    The customer and merchant payment preferences.

    Attributes:
        payee_preferred (PayeePaymentMethodPreference): The merchant-preferred
            payment methods.
        standard_entry_class_code (StandardEntryClassCode): NACHA (the
            regulatory body governing the ACH network) requires that API
            callers (merchants, partners) obtain the consumer’s explicit
            authorization before initiating a transaction. To stay compliant,
            you’ll need to make sure that you retain a compliant authorization
            for each transaction that you originate to the ACH Network using
            this API. ACH transactions are categorized (using SEC codes) by
            how you capture authorization from the Receiver (the person whose
            bank account is being debited or credited). PayPal supports the
            following SEC codes.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payee_preferred": 'payee_preferred',
        "standard_entry_class_code": 'standard_entry_class_code'
    }

    _optionals = [
        'payee_preferred',
        'standard_entry_class_code',
    ]

    def __init__(self,
                 payee_preferred='UNRESTRICTED',
                 standard_entry_class_code='WEB'):
        """Constructor for the PaymentMethodPreference class"""

        # Initialize members of the class
        self.payee_preferred = payee_preferred 
        self.standard_entry_class_code = standard_entry_class_code 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payee_preferred = dictionary.get("payee_preferred") if dictionary.get("payee_preferred") else 'UNRESTRICTED'
        standard_entry_class_code = dictionary.get("standard_entry_class_code") if dictionary.get("standard_entry_class_code") else 'WEB'
        # Return an object of this model
        return cls(payee_preferred,
                   standard_entry_class_code)
