# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.authorization_with_additional_data import AuthorizationWithAdditionalData
from paypalserversdk.models.capture import Capture
from paypalserversdk.models.refund import Refund


class PaymentCollection(object):

    """Implementation of the 'Payment Collection' model.

    The collection of payments, or transactions, for a purchase unit in an
    order. For example, authorized payments, captured payments, and refunds.

    Attributes:
        authorizations (List[AuthorizationWithAdditionalData]): An array of
            authorized payments for a purchase unit. A purchase unit can have
            zero or more authorized payments.
        captures (List[Capture]): An array of captured payments for a purchase
            unit. A purchase unit can have zero or more captured payments.
        refunds (List[Refund]): An array of refunds for a purchase unit. A
            purchase unit can have zero or more refunds.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "authorizations": 'authorizations',
        "captures": 'captures',
        "refunds": 'refunds'
    }

    _optionals = [
        'authorizations',
        'captures',
        'refunds',
    ]

    def __init__(self,
                 authorizations=APIHelper.SKIP,
                 captures=APIHelper.SKIP,
                 refunds=APIHelper.SKIP):
        """Constructor for the PaymentCollection class"""

        # Initialize members of the class
        if authorizations is not APIHelper.SKIP:
            self.authorizations = authorizations 
        if captures is not APIHelper.SKIP:
            self.captures = captures 
        if refunds is not APIHelper.SKIP:
            self.refunds = refunds 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        authorizations = None
        if dictionary.get('authorizations') is not None:
            authorizations = [AuthorizationWithAdditionalData.from_dictionary(x) for x in dictionary.get('authorizations')]
        else:
            authorizations = APIHelper.SKIP
        captures = None
        if dictionary.get('captures') is not None:
            captures = [Capture.from_dictionary(x) for x in dictionary.get('captures')]
        else:
            captures = APIHelper.SKIP
        refunds = None
        if dictionary.get('refunds') is not None:
            refunds = [Refund.from_dictionary(x) for x in dictionary.get('refunds')]
        else:
            refunds = APIHelper.SKIP
        # Return an object of this model
        return cls(authorizations,
                   captures,
                   refunds)
