# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class PayerBase(object):

    """Implementation of the 'Payer Base' model.

    The customer who approves and pays for the order. The customer is also
    known as the payer.

    Attributes:
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        payer_id (str): The account identifier for a PayPal account.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "email_address": 'email_address',
        "payer_id": 'payer_id'
    }

    _optionals = [
        'email_address',
        'payer_id',
    ]

    def __init__(self,
                 email_address=APIHelper.SKIP,
                 payer_id=APIHelper.SKIP):
        """Constructor for the PayerBase class"""

        # Initialize members of the class
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if payer_id is not APIHelper.SKIP:
            self.payer_id = payer_id 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        payer_id = dictionary.get("payer_id") if dictionary.get("payer_id") else APIHelper.SKIP
        # Return an object of this model
        return cls(email_address,
                   payer_id)
