# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.address import Address
from paypalserversdk.models.name import Name
from paypalserversdk.models.phone_with_type import PhoneWithType
from paypalserversdk.models.tax_info import TaxInfo


class Payer(object):

    """Implementation of the 'Payer' model.

    TODO: type model description here.

    Attributes:
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        payer_id (str): The account identifier for a PayPal account.
        name (Name): The name of the party.
        phone (PhoneWithType): The phone information.
        birth_date (str): The stand-alone date, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). To
            represent special legal values, such as a date of birth, you
            should use dates with no associated time or time-zone data.
            Whenever possible, use the standard `date_time` type. This regular
            expression does not validate all dates. For example, February 31
            is valid and nothing is known about leap years.
        tax_info (TaxInfo): The tax ID of the customer. The customer is also
            known as the payer. Both `tax_id` and `tax_id_type` are required.
        address (Address): The portable international postal address. Maps to
            [AddressValidationMetadata](https://github.com/googlei18n/libaddres
            sinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling
            form controls: the autocomplete
            attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-
            form-controls-the-autocomplete-attribute).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "email_address": 'email_address',
        "payer_id": 'payer_id',
        "name": 'name',
        "phone": 'phone',
        "birth_date": 'birth_date',
        "tax_info": 'tax_info',
        "address": 'address'
    }

    _optionals = [
        'email_address',
        'payer_id',
        'name',
        'phone',
        'birth_date',
        'tax_info',
        'address',
    ]

    def __init__(self,
                 email_address=APIHelper.SKIP,
                 payer_id=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 phone=APIHelper.SKIP,
                 birth_date=APIHelper.SKIP,
                 tax_info=APIHelper.SKIP,
                 address=APIHelper.SKIP):
        """Constructor for the Payer class"""

        # Initialize members of the class
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if payer_id is not APIHelper.SKIP:
            self.payer_id = payer_id 
        if name is not APIHelper.SKIP:
            self.name = name 
        if phone is not APIHelper.SKIP:
            self.phone = phone 
        if birth_date is not APIHelper.SKIP:
            self.birth_date = birth_date 
        if tax_info is not APIHelper.SKIP:
            self.tax_info = tax_info 
        if address is not APIHelper.SKIP:
            self.address = address 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        payer_id = dictionary.get("payer_id") if dictionary.get("payer_id") else APIHelper.SKIP
        name = Name.from_dictionary(dictionary.get('name')) if 'name' in dictionary.keys() else APIHelper.SKIP
        phone = PhoneWithType.from_dictionary(dictionary.get('phone')) if 'phone' in dictionary.keys() else APIHelper.SKIP
        birth_date = dictionary.get("birth_date") if dictionary.get("birth_date") else APIHelper.SKIP
        tax_info = TaxInfo.from_dictionary(dictionary.get('tax_info')) if 'tax_info' in dictionary.keys() else APIHelper.SKIP
        address = Address.from_dictionary(dictionary.get('address')) if 'address' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(email_address,
                   payer_id,
                   name,
                   phone,
                   birth_date,
                   tax_info,
                   address)
