# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class PayPalWalletVaultInstruction(object):

    """Implementation of the 'PayPal Wallet Vault Instruction' model.

    TODO: type model description here.

    Attributes:
        store_in_vault (StoreInVaultInstruction): Defines how and when the
            payment source gets vaulted.
        description (str): The description displayed to PayPal consumer on the
            approval flow for PayPal, as well as on the PayPal payment token
            management experience on PayPal.com.
        usage_pattern (PayPalPaymentTokenUsagePattern): Expected
            business/pricing model for the billing agreement.
        usage_type (PayPalPaymentTokenUsageType): The usage type associated
            with the PayPal payment token.
        customer_type (PayPalPaymentTokenCustomerType): The customer type
            associated with the PayPal payment token. This is to indicate
            whether the customer acting on the merchant / platform is either a
            business or a consumer.
        permit_multiple_payment_tokens (bool): Create multiple payment tokens
            for the same payer, merchant/platform combination. Use this when
            the customer has not logged in at merchant/platform. The payment
            token thus generated, can then also be used to create the customer
            account at merchant/platform. Use this also when multiple payment
            tokens are required for the same payer, different customer at
            merchant/platform. This helps to identify customers distinctly
            even though they may share the same PayPal account. This only
            applies to PayPal payment source.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "usage_type": 'usage_type',
        "store_in_vault": 'store_in_vault',
        "description": 'description',
        "usage_pattern": 'usage_pattern',
        "customer_type": 'customer_type',
        "permit_multiple_payment_tokens": 'permit_multiple_payment_tokens'
    }

    _optionals = [
        'store_in_vault',
        'description',
        'usage_pattern',
        'customer_type',
        'permit_multiple_payment_tokens',
    ]

    def __init__(self,
                 usage_type=None,
                 store_in_vault=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 usage_pattern=APIHelper.SKIP,
                 customer_type='CONSUMER',
                 permit_multiple_payment_tokens=False):
        """Constructor for the PayPalWalletVaultInstruction class"""

        # Initialize members of the class
        if store_in_vault is not APIHelper.SKIP:
            self.store_in_vault = store_in_vault 
        if description is not APIHelper.SKIP:
            self.description = description 
        if usage_pattern is not APIHelper.SKIP:
            self.usage_pattern = usage_pattern 
        self.usage_type = usage_type 
        self.customer_type = customer_type 
        self.permit_multiple_payment_tokens = permit_multiple_payment_tokens 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        usage_type = dictionary.get("usage_type") if dictionary.get("usage_type") else None
        store_in_vault = dictionary.get("store_in_vault") if dictionary.get("store_in_vault") else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        usage_pattern = dictionary.get("usage_pattern") if dictionary.get("usage_pattern") else APIHelper.SKIP
        customer_type = dictionary.get("customer_type") if dictionary.get("customer_type") else 'CONSUMER'
        permit_multiple_payment_tokens = dictionary.get("permit_multiple_payment_tokens") if dictionary.get("permit_multiple_payment_tokens") else False
        # Return an object of this model
        return cls(usage_type,
                   store_in_vault,
                   description,
                   usage_pattern,
                   customer_type,
                   permit_multiple_payment_tokens)
