# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class PayPalWalletExperienceContext(object):

    """Implementation of the 'PayPal Wallet Experience Context' model.

    Customizes the payer experience during the approval process for payment
    with PayPal.<blockquote><strong>Note:</strong> Partners and Marketplaces
    might configure <code>brand_name</code> and
    <code>shipping_preference</code> during partner account setup, which
    overrides the request values.</blockquote>

    Attributes:
        brand_name (str): The label that overrides the business name in the
            PayPal account on the PayPal site. The pattern is defined by an
            external party and supports Unicode.
        locale (str): The [language
            tag](https://tools.ietf.org/html/bcp47#section-2) for the language
            in which to localize the error-related strings, such as messages,
            issues, and suggested actions. The tag is made up of the [ISO
            639-2 language
            code](https://www.loc.gov/standards/iso639-2/php/code_list.php),
            the optional [ISO-15924 script
            tag](https://www.unicode.org/iso15924/codelists.html), and the
            [ISO-3166 alpha-2 country
            code](/api/rest/reference/country-codes/) or [M49 region
            code](https://unstats.un.org/unsd/methodology/m49/).
        shipping_preference (ShippingPreference): The location from which the
            shipping address is derived.
        return_url (str): Describes the URL.
        cancel_url (str): Describes the URL.
        landing_page (PayPalExperienceLandingPage): The type of landing page
            to show on the PayPal site for customer checkout.
        user_action (PayPalExperienceUserAction): Configures a
            <strong>Continue</strong> or <strong>Pay Now</strong> checkout
            flow.
        payment_method_preference (PayeePaymentMethodPreference): The
            merchant-preferred payment methods.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "locale": 'locale',
        "shipping_preference": 'shipping_preference',
        "return_url": 'return_url',
        "cancel_url": 'cancel_url',
        "landing_page": 'landing_page',
        "user_action": 'user_action',
        "payment_method_preference": 'payment_method_preference'
    }

    _optionals = [
        'brand_name',
        'locale',
        'shipping_preference',
        'return_url',
        'cancel_url',
        'landing_page',
        'user_action',
        'payment_method_preference',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 locale=APIHelper.SKIP,
                 shipping_preference='GET_FROM_FILE',
                 return_url=APIHelper.SKIP,
                 cancel_url=APIHelper.SKIP,
                 landing_page='NO_PREFERENCE',
                 user_action='CONTINUE',
                 payment_method_preference='UNRESTRICTED'):
        """Constructor for the PayPalWalletExperienceContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        if locale is not APIHelper.SKIP:
            self.locale = locale 
        self.shipping_preference = shipping_preference 
        if return_url is not APIHelper.SKIP:
            self.return_url = return_url 
        if cancel_url is not APIHelper.SKIP:
            self.cancel_url = cancel_url 
        self.landing_page = landing_page 
        self.user_action = user_action 
        self.payment_method_preference = payment_method_preference 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        locale = dictionary.get("locale") if dictionary.get("locale") else APIHelper.SKIP
        shipping_preference = dictionary.get("shipping_preference") if dictionary.get("shipping_preference") else 'GET_FROM_FILE'
        return_url = dictionary.get("return_url") if dictionary.get("return_url") else APIHelper.SKIP
        cancel_url = dictionary.get("cancel_url") if dictionary.get("cancel_url") else APIHelper.SKIP
        landing_page = dictionary.get("landing_page") if dictionary.get("landing_page") else 'NO_PREFERENCE'
        user_action = dictionary.get("user_action") if dictionary.get("user_action") else 'CONTINUE'
        payment_method_preference = dictionary.get("payment_method_preference") if dictionary.get("payment_method_preference") else 'UNRESTRICTED'
        # Return an object of this model
        return cls(brand_name,
                   locale,
                   shipping_preference,
                   return_url,
                   cancel_url,
                   landing_page,
                   user_action,
                   payment_method_preference)
