# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.pay_pal_wallet_customer_request import PayPalWalletCustomerRequest
from paypalserversdk.models.pay_pal_wallet_vault_instruction import PayPalWalletVaultInstruction


class PayPalWalletAttributes(object):

    """Implementation of the 'PayPal Wallet Attributes' model.

    Additional attributes associated with the use of this PayPal Wallet.

    Attributes:
        customer (PayPalWalletCustomerRequest): TODO: type description here.
        vault (PayPalWalletVaultInstruction): TODO: type description here.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "customer": 'customer',
        "vault": 'vault'
    }

    _optionals = [
        'customer',
        'vault',
    ]

    def __init__(self,
                 customer=APIHelper.SKIP,
                 vault=APIHelper.SKIP):
        """Constructor for the PayPalWalletAttributes class"""

        # Initialize members of the class
        if customer is not APIHelper.SKIP:
            self.customer = customer 
        if vault is not APIHelper.SKIP:
            self.vault = vault 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        customer = PayPalWalletCustomerRequest.from_dictionary(dictionary.get('customer')) if 'customer' in dictionary.keys() else APIHelper.SKIP
        vault = PayPalWalletVaultInstruction.from_dictionary(dictionary.get('vault')) if 'vault' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(customer,
                   vault)
