# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class Patch(object):

    """Implementation of the 'Patch' model.

    The JSON patch object to apply partial updates to resources.

    Attributes:
        op (PatchOp): The operation.
        path (str): The <a href="https://tools.ietf.org/html/rfc6901">JSON
            Pointer</a> to the target document location at which to complete
            the operation.
        value (object): The value to apply. The <code>remove</code>,
            <code>copy</code>, and <code>move</code> operations do not require
            a value. Since <a
            href="https://www.rfc-editor.org/rfc/rfc69021">JSON Patch</a>
            allows any type for <code>value</code>, the <code>type</code>
            property is not specified.
        mfrom (str): The <a href="https://tools.ietf.org/html/rfc6901">JSON
            Pointer</a> to the target document location from which to move the
            value. Required for the <code>move</code> operation.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "op": 'op',
        "path": 'path',
        "value": 'value',
        "mfrom": 'from'
    }

    _optionals = [
        'path',
        'value',
        'mfrom',
    ]

    def __init__(self,
                 op=None,
                 path=APIHelper.SKIP,
                 value=APIHelper.SKIP,
                 mfrom=APIHelper.SKIP):
        """Constructor for the Patch class"""

        # Initialize members of the class
        self.op = op 
        if path is not APIHelper.SKIP:
            self.path = path 
        if value is not APIHelper.SKIP:
            self.value = value 
        if mfrom is not APIHelper.SKIP:
            self.mfrom = mfrom 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        op = dictionary.get("op") if dictionary.get("op") else None
        path = dictionary.get("path") if dictionary.get("path") else APIHelper.SKIP
        value = dictionary.get("value") if dictionary.get("value") else APIHelper.SKIP
        mfrom = dictionary.get("from") if dictionary.get("from") else APIHelper.SKIP
        # Return an object of this model
        return cls(op,
                   path,
                   value,
                   mfrom)
