# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class P24PaymentObject(object):

    """Implementation of the 'P24 Payment Object' model.

    Information used to pay using P24(Przelewy24).

    Attributes:
        name (str): The full name representation like Mr J Smith.
        email (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        country_code (str): The [two-character ISO 3166-1
            code](/api/rest/reference/country-codes/) that identifies the
            country or region.<blockquote><strong>Note:</strong> The country
            code for Great Britain is <code>GB</code> and not <code>UK</code>
            as used in the top-level domain names for that country. Use the
            `C2` country code for China worldwide for comparable uncontrolled
            price (CUP) method, bank card, and cross-border
            transactions.</blockquote>
        payment_descriptor (str): P24 generated payment description.
        method_id (str): Numeric identifier of the payment scheme or bank used
            for the payment.
        method_description (str): Friendly name of the payment scheme or bank
            used for the payment.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "email": 'email',
        "country_code": 'country_code',
        "payment_descriptor": 'payment_descriptor',
        "method_id": 'method_id',
        "method_description": 'method_description'
    }

    _optionals = [
        'name',
        'email',
        'country_code',
        'payment_descriptor',
        'method_id',
        'method_description',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 payment_descriptor=APIHelper.SKIP,
                 method_id=APIHelper.SKIP,
                 method_description=APIHelper.SKIP):
        """Constructor for the P24PaymentObject class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if email is not APIHelper.SKIP:
            self.email = email 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if payment_descriptor is not APIHelper.SKIP:
            self.payment_descriptor = payment_descriptor 
        if method_id is not APIHelper.SKIP:
            self.method_id = method_id 
        if method_description is not APIHelper.SKIP:
            self.method_description = method_description 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        payment_descriptor = dictionary.get("payment_descriptor") if dictionary.get("payment_descriptor") else APIHelper.SKIP
        method_id = dictionary.get("method_id") if dictionary.get("method_id") else APIHelper.SKIP
        method_description = dictionary.get("method_description") if dictionary.get("method_description") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   email,
                   country_code,
                   payment_descriptor,
                   method_id,
                   method_description)
