# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.link_description import LinkDescription
from paypalserversdk.models.order_tracker_item import OrderTrackerItem


class OrderTrackerResponse(object):

    """Implementation of the 'Order Tracker Response' model.

    The tracking response on creation of tracker.

    Attributes:
        id (str): The tracker id.
        status (OrderTrackerStatus): The status of the item shipment.
        items (List[OrderTrackerItem]): An array of details of items in the
            shipment.
        links (List[LinkDescription]): An array of request-related HATEOAS
            links.
        create_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        update_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "status": 'status',
        "items": 'items',
        "links": 'links',
        "create_time": 'create_time',
        "update_time": 'update_time'
    }

    _optionals = [
        'id',
        'status',
        'items',
        'links',
        'create_time',
        'update_time',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 status=APIHelper.SKIP,
                 items=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 create_time=APIHelper.SKIP,
                 update_time=APIHelper.SKIP):
        """Constructor for the OrderTrackerResponse class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if status is not APIHelper.SKIP:
            self.status = status 
        if items is not APIHelper.SKIP:
            self.items = items 
        if links is not APIHelper.SKIP:
            self.links = links 
        if create_time is not APIHelper.SKIP:
            self.create_time = create_time 
        if update_time is not APIHelper.SKIP:
            self.update_time = update_time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        items = None
        if dictionary.get('items') is not None:
            items = [OrderTrackerItem.from_dictionary(x) for x in dictionary.get('items')]
        else:
            items = APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        create_time = dictionary.get("create_time") if dictionary.get("create_time") else APIHelper.SKIP
        update_time = dictionary.get("update_time") if dictionary.get("update_time") else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   status,
                   items,
                   links,
                   create_time,
                   update_time)
