# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.order_tracker_item import OrderTrackerItem


class OrderTrackerRequest(object):

    """Implementation of the 'Order Tracker Request' model.

    The tracking details of an order.

    Attributes:
        tracking_number (str): The tracking number for the shipment. This
            property supports Unicode.
        carrier (ShipmentCarrier): The carrier for the shipment. Some carriers
            have a global version as well as local subsidiaries. The
            subsidiaries are repeated over many countries and might also have
            an entry in the global list. Choose the carrier for your country.
            If the carrier is not available for your country, choose the
            global version of the carrier. If your carrier name is not in the
            list, set `carrier` to `OTHER` and set carrier name in
            `carrier_name_other`. For allowed values, see <a
            href="/docs/tracking/reference/carriers/">Carriers</a>.
        carrier_name_other (str): The name of the carrier for the shipment.
            Provide this value only if the carrier parameter is OTHER. This
            property supports Unicode.
        capture_id (str): The PayPal capture ID.
        notify_payer (bool): If true, sends an email notification to the payer
            of the PayPal transaction. The email contains the tracking
            information that was uploaded through the API.
        items (List[OrderTrackerItem]): An array of details of items in the
            shipment.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "capture_id": 'capture_id',
        "tracking_number": 'tracking_number',
        "carrier": 'carrier',
        "carrier_name_other": 'carrier_name_other',
        "notify_payer": 'notify_payer',
        "items": 'items'
    }

    _optionals = [
        'tracking_number',
        'carrier',
        'carrier_name_other',
        'notify_payer',
        'items',
    ]

    def __init__(self,
                 capture_id=None,
                 tracking_number=APIHelper.SKIP,
                 carrier=APIHelper.SKIP,
                 carrier_name_other=APIHelper.SKIP,
                 notify_payer=False,
                 items=APIHelper.SKIP):
        """Constructor for the OrderTrackerRequest class"""

        # Initialize members of the class
        if tracking_number is not APIHelper.SKIP:
            self.tracking_number = tracking_number 
        if carrier is not APIHelper.SKIP:
            self.carrier = carrier 
        if carrier_name_other is not APIHelper.SKIP:
            self.carrier_name_other = carrier_name_other 
        self.capture_id = capture_id 
        self.notify_payer = notify_payer 
        if items is not APIHelper.SKIP:
            self.items = items 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        capture_id = dictionary.get("capture_id") if dictionary.get("capture_id") else None
        tracking_number = dictionary.get("tracking_number") if dictionary.get("tracking_number") else APIHelper.SKIP
        carrier = dictionary.get("carrier") if dictionary.get("carrier") else APIHelper.SKIP
        carrier_name_other = dictionary.get("carrier_name_other") if dictionary.get("carrier_name_other") else APIHelper.SKIP
        notify_payer = dictionary.get("notify_payer") if dictionary.get("notify_payer") else False
        items = None
        if dictionary.get('items') is not None:
            items = [OrderTrackerItem.from_dictionary(x) for x in dictionary.get('items')]
        else:
            items = APIHelper.SKIP
        # Return an object of this model
        return cls(capture_id,
                   tracking_number,
                   carrier,
                   carrier_name_other,
                   notify_payer,
                   items)
