# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.universal_product_code import UniversalProductCode


class OrderTrackerItem(object):

    """Implementation of the 'Order Tracker Item' model.

    The details of the items in the shipment.

    Attributes:
        name (str): The item name or title.
        quantity (str): The item quantity. Must be a whole number.
        sku (str): The stock keeping unit (SKU) for the item. This can contain
            unicode characters.
        url (str): The URL to the item being purchased. Visible to buyer and
            used in buyer experiences.
        image_url (str): The URL of the item's image. File type and size
            restrictions apply. An image that violates these restrictions will
            not be honored.
        upc (UniversalProductCode): The Universal Product Code of the item.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "quantity": 'quantity',
        "sku": 'sku',
        "url": 'url',
        "image_url": 'image_url',
        "upc": 'upc'
    }

    _optionals = [
        'name',
        'quantity',
        'sku',
        'url',
        'image_url',
        'upc',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 quantity=APIHelper.SKIP,
                 sku=APIHelper.SKIP,
                 url=APIHelper.SKIP,
                 image_url=APIHelper.SKIP,
                 upc=APIHelper.SKIP):
        """Constructor for the OrderTrackerItem class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if quantity is not APIHelper.SKIP:
            self.quantity = quantity 
        if sku is not APIHelper.SKIP:
            self.sku = sku 
        if url is not APIHelper.SKIP:
            self.url = url 
        if image_url is not APIHelper.SKIP:
            self.image_url = image_url 
        if upc is not APIHelper.SKIP:
            self.upc = upc 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        quantity = dictionary.get("quantity") if dictionary.get("quantity") else APIHelper.SKIP
        sku = dictionary.get("sku") if dictionary.get("sku") else APIHelper.SKIP
        url = dictionary.get("url") if dictionary.get("url") else APIHelper.SKIP
        image_url = dictionary.get("image_url") if dictionary.get("image_url") else APIHelper.SKIP
        upc = UniversalProductCode.from_dictionary(dictionary.get('upc')) if 'upc' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   quantity,
                   sku,
                   url,
                   image_url,
                   upc)
