# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.order_application_context import OrderApplicationContext
from paypalserversdk.models.payer import Payer
from paypalserversdk.models.payment_source import PaymentSource
from paypalserversdk.models.purchase_unit_request import PurchaseUnitRequest


class OrderRequest(object):

    """Implementation of the 'Order Request' model.

    The order request details.

    Attributes:
        intent (CheckoutPaymentIntent): The intent to either capture payment
            immediately or authorize a payment for an order after order
            creation.
        payer (Payer): TODO: type description here.
        purchase_units (List[PurchaseUnitRequest]): An array of purchase
            units. Each purchase unit establishes a contract between a payer
            and the payee. Each purchase unit represents either a full or
            partial order that the payer intends to purchase from the payee.
        payment_source (PaymentSource): The payment source definition.
        application_context (OrderApplicationContext): Customizes the payer
            experience during the approval process for the payment with
            PayPal.<blockquote><strong>Note:</strong> Partners and
            Marketplaces might configure <code>brand_name</code> and
            <code>shipping_preference</code> during partner account setup,
            which overrides the request values.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "intent": 'intent',
        "purchase_units": 'purchase_units',
        "payer": 'payer',
        "payment_source": 'payment_source',
        "application_context": 'application_context'
    }

    _optionals = [
        'payer',
        'payment_source',
        'application_context',
    ]

    def __init__(self,
                 intent=None,
                 purchase_units=None,
                 payer=APIHelper.SKIP,
                 payment_source=APIHelper.SKIP,
                 application_context=APIHelper.SKIP):
        """Constructor for the OrderRequest class"""

        # Initialize members of the class
        self.intent = intent 
        if payer is not APIHelper.SKIP:
            self.payer = payer 
        self.purchase_units = purchase_units 
        if payment_source is not APIHelper.SKIP:
            self.payment_source = payment_source 
        if application_context is not APIHelper.SKIP:
            self.application_context = application_context 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        intent = dictionary.get("intent") if dictionary.get("intent") else None
        purchase_units = None
        if dictionary.get('purchase_units') is not None:
            purchase_units = [PurchaseUnitRequest.from_dictionary(x) for x in dictionary.get('purchase_units')]
        payer = Payer.from_dictionary(dictionary.get('payer')) if 'payer' in dictionary.keys() else APIHelper.SKIP
        payment_source = PaymentSource.from_dictionary(dictionary.get('payment_source')) if 'payment_source' in dictionary.keys() else APIHelper.SKIP
        application_context = OrderApplicationContext.from_dictionary(dictionary.get('application_context')) if 'application_context' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(intent,
                   purchase_units,
                   payer,
                   payment_source,
                   application_context)
