# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.stored_payment_source import StoredPaymentSource


class OrderConfirmApplicationContext(object):

    """Implementation of the 'Order Confirm Application Context' model.

    Customizes the payer confirmation experience.

    Attributes:
        brand_name (str): Label to present to your payer as part of the PayPal
            hosted web experience.
        locale (str): The [language
            tag](https://tools.ietf.org/html/bcp47#section-2) for the language
            in which to localize the error-related strings, such as messages,
            issues, and suggested actions. The tag is made up of the [ISO
            639-2 language
            code](https://www.loc.gov/standards/iso639-2/php/code_list.php),
            the optional [ISO-15924 script
            tag](https://www.unicode.org/iso15924/codelists.html), and the
            [ISO-3166 alpha-2 country
            code](/api/rest/reference/country-codes/) or [M49 region
            code](https://unstats.un.org/unsd/methodology/m49/).
        return_url (str): The URL where the customer is redirected after the
            customer approves the payment.
        cancel_url (str): The URL where the customer is redirected after the
            customer cancels the payment.
        stored_payment_source (StoredPaymentSource): Provides additional
            details to process a payment using a `payment_source` that has
            been stored or is intended to be stored (also referred to as
            stored_credential or card-on-file).<br/>Parameter
            compatibility:<br/><ul><li>`payment_type=ONE_TIME` is compatible
            only with `payment_initiator=CUSTOMER`.</li><li>`usage=FIRST` is
            compatible only with
            `payment_initiator=CUSTOMER`.</li><li>`previous_transaction_referen
            ce` or `previous_network_transaction_reference` is compatible only
            with `payment_initiator=MERCHANT`.</li><li>Only one of the
            parameters - `previous_transaction_reference` and
            `previous_network_transaction_reference` - can be present in the
            request.</li></ul>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "locale": 'locale',
        "return_url": 'return_url',
        "cancel_url": 'cancel_url',
        "stored_payment_source": 'stored_payment_source'
    }

    _optionals = [
        'brand_name',
        'locale',
        'return_url',
        'cancel_url',
        'stored_payment_source',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 locale=APIHelper.SKIP,
                 return_url=APIHelper.SKIP,
                 cancel_url=APIHelper.SKIP,
                 stored_payment_source=APIHelper.SKIP):
        """Constructor for the OrderConfirmApplicationContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        if locale is not APIHelper.SKIP:
            self.locale = locale 
        if return_url is not APIHelper.SKIP:
            self.return_url = return_url 
        if cancel_url is not APIHelper.SKIP:
            self.cancel_url = cancel_url 
        if stored_payment_source is not APIHelper.SKIP:
            self.stored_payment_source = stored_payment_source 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        locale = dictionary.get("locale") if dictionary.get("locale") else APIHelper.SKIP
        return_url = dictionary.get("return_url") if dictionary.get("return_url") else APIHelper.SKIP
        cancel_url = dictionary.get("cancel_url") if dictionary.get("cancel_url") else APIHelper.SKIP
        stored_payment_source = StoredPaymentSource.from_dictionary(dictionary.get('stored_payment_source')) if 'stored_payment_source' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(brand_name,
                   locale,
                   return_url,
                   cancel_url,
                   stored_payment_source)
