# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_request import ApplePayRequest
from paypalserversdk.models.card_request import CardRequest
from paypalserversdk.models.google_pay_request import GooglePayRequest
from paypalserversdk.models.pay_pal_wallet import PayPalWallet
from paypalserversdk.models.token import Token
from paypalserversdk.models.venmo_wallet_request import VenmoWalletRequest


class OrderCaptureRequestPaymentSource(object):

    """Implementation of the 'Order Capture Request Payment Source' model.

    The payment source definition.

    Attributes:
        card (CardRequest): The payment card to use to fund a payment. Can be
            a credit or debit card.<blockquote><strong>Note:</strong> Passing
            card number, cvv and expiry directly via the API requires <a
            href="https://www.pcisecuritystandards.org/pci_security/completing_
            self_assessment"> PCI SAQ D compliance</a>. <br>*PayPal offers a
            mechanism by which you do not have to take on the <strong>PCI SAQ
            D</strong> burden by using hosted fields - refer to <a
            href="https://developer.paypal.com/docs/checkout/advanced/integrate
            /">this Integration Guide</a>*.</blockquote>
        token (Token): The tokenized payment source to fund a payment.
        paypal (PayPalWallet): A resource that identifies a PayPal Wallet is
            used for payment.
        apple_pay (ApplePayRequest): Information needed to pay using
            ApplePay.
        google_pay (GooglePayRequest): Information needed to pay using Google
            Pay.
        venmo (VenmoWalletRequest): Information needed to pay using Venmo.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "token": 'token',
        "paypal": 'paypal',
        "apple_pay": 'apple_pay',
        "google_pay": 'google_pay',
        "venmo": 'venmo'
    }

    _optionals = [
        'card',
        'token',
        'paypal',
        'apple_pay',
        'google_pay',
        'venmo',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 token=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 apple_pay=APIHelper.SKIP,
                 google_pay=APIHelper.SKIP,
                 venmo=APIHelper.SKIP):
        """Constructor for the OrderCaptureRequestPaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if token is not APIHelper.SKIP:
            self.token = token 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if apple_pay is not APIHelper.SKIP:
            self.apple_pay = apple_pay 
        if google_pay is not APIHelper.SKIP:
            self.google_pay = google_pay 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = CardRequest.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        token = Token.from_dictionary(dictionary.get('token')) if 'token' in dictionary.keys() else APIHelper.SKIP
        paypal = PayPalWallet.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        apple_pay = ApplePayRequest.from_dictionary(dictionary.get('apple_pay')) if 'apple_pay' in dictionary.keys() else APIHelper.SKIP
        google_pay = GooglePayRequest.from_dictionary(dictionary.get('google_pay')) if 'google_pay' in dictionary.keys() else APIHelper.SKIP
        venmo = VenmoWalletRequest.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   token,
                   paypal,
                   apple_pay,
                   google_pay,
                   venmo)
