# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.order_capture_request_payment_source import OrderCaptureRequestPaymentSource


class OrderCaptureRequest(object):

    """Implementation of the 'Order Capture Request' model.

    Completes an capture payment for an order.

    Attributes:
        payment_source (OrderCaptureRequestPaymentSource): The payment source
            definition.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_source": 'payment_source'
    }

    _optionals = [
        'payment_source',
    ]

    def __init__(self,
                 payment_source=APIHelper.SKIP):
        """Constructor for the OrderCaptureRequest class"""

        # Initialize members of the class
        if payment_source is not APIHelper.SKIP:
            self.payment_source = payment_source 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_source = OrderCaptureRequestPaymentSource.from_dictionary(dictionary.get('payment_source')) if 'payment_source' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(payment_source)
