# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_payment_object import ApplePayPaymentObject
from paypalserversdk.models.card_response import CardResponse
from paypalserversdk.models.google_pay_wallet_response import GooglePayWalletResponse
from paypalserversdk.models.pay_pal_wallet_response import PayPalWalletResponse
from paypalserversdk.models.venmo_wallet_response import VenmoWalletResponse


class OrderAuthorizeResponsePaymentSource(object):

    """Implementation of the 'Order Authorize Response Payment Source' model.

    The payment source used to fund the payment.

    Attributes:
        card (CardResponse): The payment card to use to fund a payment. Card
            can be a credit or debit card.
        paypal (PayPalWalletResponse): The PayPal Wallet response.
        apple_pay (ApplePayPaymentObject): Information needed to pay using
            ApplePay.
        google_pay (GooglePayWalletResponse): Google Pay Wallet payment data.
        venmo (VenmoWalletResponse): Venmo wallet response.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card',
        "paypal": 'paypal',
        "apple_pay": 'apple_pay',
        "google_pay": 'google_pay',
        "venmo": 'venmo'
    }

    _optionals = [
        'card',
        'paypal',
        'apple_pay',
        'google_pay',
        'venmo',
    ]

    def __init__(self,
                 card=APIHelper.SKIP,
                 paypal=APIHelper.SKIP,
                 apple_pay=APIHelper.SKIP,
                 google_pay=APIHelper.SKIP,
                 venmo=APIHelper.SKIP):
        """Constructor for the OrderAuthorizeResponsePaymentSource class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 
        if paypal is not APIHelper.SKIP:
            self.paypal = paypal 
        if apple_pay is not APIHelper.SKIP:
            self.apple_pay = apple_pay 
        if google_pay is not APIHelper.SKIP:
            self.google_pay = google_pay 
        if venmo is not APIHelper.SKIP:
            self.venmo = venmo 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = CardResponse.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        paypal = PayPalWalletResponse.from_dictionary(dictionary.get('paypal')) if 'paypal' in dictionary.keys() else APIHelper.SKIP
        apple_pay = ApplePayPaymentObject.from_dictionary(dictionary.get('apple_pay')) if 'apple_pay' in dictionary.keys() else APIHelper.SKIP
        google_pay = GooglePayWalletResponse.from_dictionary(dictionary.get('google_pay')) if 'google_pay' in dictionary.keys() else APIHelper.SKIP
        venmo = VenmoWalletResponse.from_dictionary(dictionary.get('venmo')) if 'venmo' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card,
                   paypal,
                   apple_pay,
                   google_pay,
                   venmo)
