# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.payment_method_preference import PaymentMethodPreference
from paypalserversdk.models.stored_payment_source import StoredPaymentSource


class OrderApplicationContext(object):

    """Implementation of the 'Order Application Context' model.

    Customizes the payer experience during the approval process for the
    payment with PayPal.<blockquote><strong>Note:</strong> Partners and
    Marketplaces might configure <code>brand_name</code> and
    <code>shipping_preference</code> during partner account setup, which
    overrides the request values.</blockquote>

    Attributes:
        brand_name (str): DEPRECATED. The label that overrides the business
            name in the PayPal account on the PayPal site. The fields in
            `application_context` are now available in the
            `experience_context` object under the `payment_source` which
            supports them (eg.
            `payment_source.paypal.experience_context.brand_name`). Please
            specify this field in the `experience_context` object instead of
            the `application_context` object.
        locale (str): The [language
            tag](https://tools.ietf.org/html/bcp47#section-2) for the language
            in which to localize the error-related strings, such as messages,
            issues, and suggested actions. The tag is made up of the [ISO
            639-2 language
            code](https://www.loc.gov/standards/iso639-2/php/code_list.php),
            the optional [ISO-15924 script
            tag](https://www.unicode.org/iso15924/codelists.html), and the
            [ISO-3166 alpha-2 country
            code](/api/rest/reference/country-codes/) or [M49 region
            code](https://unstats.un.org/unsd/methodology/m49/).
        landing_page (OrderApplicationContextLandingPage): DEPRECATED.
            DEPRECATED. The type of landing page to show on the PayPal site
            for customer checkout.  The fields in `application_context` are
            now available in the `experience_context` object under the
            `payment_source` which supports them (eg.
            `payment_source.paypal.experience_context.landing_page`). Please
            specify this field in the `experience_context` object instead of
            the `application_context` object.
        shipping_preference (OrderApplicationContextShippingPreference):
            DEPRECATED. DEPRECATED. The shipping preference:<ul><li>Displays
            the shipping address to the customer.</li><li>Enables the customer
            to choose an address on the PayPal site.</li><li>Restricts the
            customer from changing the address during the payment-approval
            process.</li></ul>.  The fields in `application_context` are now
            available in the `experience_context` object under the
            `payment_source` which supports them (eg.
            `payment_source.paypal.experience_context.shipping_preference`).
            Please specify this field in the `experience_context` object
            instead of the `application_context` object.
        user_action (OrderApplicationContextUserAction): DEPRECATED.
            Configures a <strong>Continue</strong> or <strong>Pay Now</strong>
            checkout flow.  The fields in `application_context` are now
            available in the `experience_context` object under the
            `payment_source` which supports them (eg.
            `payment_source.paypal.experience_context.user_action`). Please
            specify this field in the `experience_context` object instead of
            the `application_context` object.
        payment_method (PaymentMethodPreference): The customer and merchant
            payment preferences.
        return_url (str): DEPRECATED. The URL where the customer is redirected
            after the customer approves the payment. The fields in
            `application_context` are now available in the
            `experience_context` object under the `payment_source` which
            supports them (eg.
            `payment_source.paypal.experience_context.return_url`). Please
            specify this field in the `experience_context` object instead of
            the `application_context` object.
        cancel_url (str): DEPRECATED. The URL where the customer is redirected
            after the customer cancels the payment. The fields in
            `application_context` are now available in the
            `experience_context` object under the `payment_source` which
            supports them (eg.
            `payment_source.paypal.experience_context.cancel_url`). Please
            specify this field in the `experience_context` object instead of
            the `application_context` object.
        stored_payment_source (StoredPaymentSource): Provides additional
            details to process a payment using a `payment_source` that has
            been stored or is intended to be stored (also referred to as
            stored_credential or card-on-file).<br/>Parameter
            compatibility:<br/><ul><li>`payment_type=ONE_TIME` is compatible
            only with `payment_initiator=CUSTOMER`.</li><li>`usage=FIRST` is
            compatible only with
            `payment_initiator=CUSTOMER`.</li><li>`previous_transaction_referen
            ce` or `previous_network_transaction_reference` is compatible only
            with `payment_initiator=MERCHANT`.</li><li>Only one of the
            parameters - `previous_transaction_reference` and
            `previous_network_transaction_reference` - can be present in the
            request.</li></ul>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "locale": 'locale',
        "landing_page": 'landing_page',
        "shipping_preference": 'shipping_preference',
        "user_action": 'user_action',
        "payment_method": 'payment_method',
        "return_url": 'return_url',
        "cancel_url": 'cancel_url',
        "stored_payment_source": 'stored_payment_source'
    }

    _optionals = [
        'brand_name',
        'locale',
        'landing_page',
        'shipping_preference',
        'user_action',
        'payment_method',
        'return_url',
        'cancel_url',
        'stored_payment_source',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 locale=APIHelper.SKIP,
                 landing_page='NO_PREFERENCE',
                 shipping_preference='GET_FROM_FILE',
                 user_action='CONTINUE',
                 payment_method=APIHelper.SKIP,
                 return_url=APIHelper.SKIP,
                 cancel_url=APIHelper.SKIP,
                 stored_payment_source=APIHelper.SKIP):
        """Constructor for the OrderApplicationContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        if locale is not APIHelper.SKIP:
            self.locale = locale 
        self.landing_page = landing_page 
        self.shipping_preference = shipping_preference 
        self.user_action = user_action 
        if payment_method is not APIHelper.SKIP:
            self.payment_method = payment_method 
        if return_url is not APIHelper.SKIP:
            self.return_url = return_url 
        if cancel_url is not APIHelper.SKIP:
            self.cancel_url = cancel_url 
        if stored_payment_source is not APIHelper.SKIP:
            self.stored_payment_source = stored_payment_source 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        locale = dictionary.get("locale") if dictionary.get("locale") else APIHelper.SKIP
        landing_page = dictionary.get("landing_page") if dictionary.get("landing_page") else 'NO_PREFERENCE'
        shipping_preference = dictionary.get("shipping_preference") if dictionary.get("shipping_preference") else 'GET_FROM_FILE'
        user_action = dictionary.get("user_action") if dictionary.get("user_action") else 'CONTINUE'
        payment_method = PaymentMethodPreference.from_dictionary(dictionary.get('payment_method')) if 'payment_method' in dictionary.keys() else APIHelper.SKIP
        return_url = dictionary.get("return_url") if dictionary.get("return_url") else APIHelper.SKIP
        cancel_url = dictionary.get("cancel_url") if dictionary.get("cancel_url") else APIHelper.SKIP
        stored_payment_source = StoredPaymentSource.from_dictionary(dictionary.get('stored_payment_source')) if 'stored_payment_source' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(brand_name,
                   locale,
                   landing_page,
                   shipping_preference,
                   user_action,
                   payment_method,
                   return_url,
                   cancel_url,
                   stored_payment_source)
