# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class NetworkTransactionReferenceEntity(object):

    """Implementation of the 'Network Transaction Reference Entity' model.

    Previous network transaction reference including id and network.

    Attributes:
        id (str): Transaction reference id returned by the scheme. For Visa
            and Amex, this is the "Tran id" field in response. For MasterCard,
            this is the "BankNet reference id" field in response. For
            Discover, this is the "NRID" field in response. The pattern we
            expect for this field from Visa/Amex/CB/Discover is numeric,
            Mastercard/BNPP is alphanumeric and Paysecure is alphanumeric with
            special character -.
        date (str): The date that the transaction was authorized by the
            scheme. This field may not be returned for all networks.
            MasterCard refers to this field as "BankNet reference date.
        network (CardBrand): The card network or brand. Applies to credit,
            debit, gift, and payment cards.
        time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "date": 'date',
        "network": 'network',
        "time": 'time'
    }

    _optionals = [
        'date',
        'network',
        'time',
    ]

    def __init__(self,
                 id=None,
                 date=APIHelper.SKIP,
                 network=APIHelper.SKIP,
                 time=APIHelper.SKIP):
        """Constructor for the NetworkTransactionReferenceEntity class"""

        # Initialize members of the class
        self.id = id 
        if date is not APIHelper.SKIP:
            self.date = date 
        if network is not APIHelper.SKIP:
            self.network = network 
        if time is not APIHelper.SKIP:
            self.time = time 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else None
        date = dictionary.get("date") if dictionary.get("date") else APIHelper.SKIP
        network = dictionary.get("network") if dictionary.get("network") else APIHelper.SKIP
        time = dictionary.get("time") if dictionary.get("time") else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   date,
                   network,
                   time)
