# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class NetworkToken(object):

    """Implementation of the 'Network Token' model.

    The Third Party Network token used to fund a payment.

    Attributes:
        number (str): Third party network token number.
        expiry (str): The year and month, in ISO-8601 `YYYY-MM` date format.
            See [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6).
        cryptogram (str): An Encrypted one-time use value that's sent along
            with Network Token. This field is not required to be present for
            recurring transactions.
        eci_flag (ECIFlag): Electronic Commerce Indicator (ECI). The ECI value
            is part of the 2 data elements that indicate the transaction was
            processed electronically. This should be passed on the
            authorization transaction to the Gateway/Processor.
        token_requestor_id (str): A TRID, or a Token Requestor ID, is an
            identifier used by merchants to request network tokens from card
            networks. A TRID is a precursor to obtaining a network token for a
            credit card primary account number (PAN), and will aid in enabling
            secure card on file (COF) payments and reducing fraud.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "number": 'number',
        "expiry": 'expiry',
        "cryptogram": 'cryptogram',
        "eci_flag": 'eci_flag',
        "token_requestor_id": 'token_requestor_id'
    }

    _optionals = [
        'cryptogram',
        'eci_flag',
        'token_requestor_id',
    ]

    def __init__(self,
                 number=None,
                 expiry=None,
                 cryptogram=APIHelper.SKIP,
                 eci_flag=APIHelper.SKIP,
                 token_requestor_id=APIHelper.SKIP):
        """Constructor for the NetworkToken class"""

        # Initialize members of the class
        self.number = number 
        self.expiry = expiry 
        if cryptogram is not APIHelper.SKIP:
            self.cryptogram = cryptogram 
        if eci_flag is not APIHelper.SKIP:
            self.eci_flag = eci_flag 
        if token_requestor_id is not APIHelper.SKIP:
            self.token_requestor_id = token_requestor_id 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        number = dictionary.get("number") if dictionary.get("number") else None
        expiry = dictionary.get("expiry") if dictionary.get("expiry") else None
        cryptogram = dictionary.get("cryptogram") if dictionary.get("cryptogram") else APIHelper.SKIP
        eci_flag = dictionary.get("eci_flag") if dictionary.get("eci_flag") else APIHelper.SKIP
        token_requestor_id = dictionary.get("token_requestor_id") if dictionary.get("token_requestor_id") else APIHelper.SKIP
        # Return an object of this model
        return cls(number,
                   expiry,
                   cryptogram,
                   eci_flag,
                   token_requestor_id)
