# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class LinkDescription(object):

    """Implementation of the 'Link Description' model.

    The request-related [HATEOAS link](/api/rest/responses/#hateoas-links)
    information.

    Attributes:
        href (str): The complete target URL. To make the related call, combine
            the method with this [URI
            Template-formatted](https://tools.ietf.org/html/rfc6570) link. For
            pre-processing, include the `$`, `(`, and `)` characters. The
            `href` is the key HATEOAS component that links a completed call
            with a subsequent call.
        rel (str): The [link relation
            type](https://tools.ietf.org/html/rfc5988#section-4), which serves
            as an ID for a link that unambiguously describes the semantics of
            the link. See [Link
            Relations](https://www.iana.org/assignments/link-relations/link-rel
            ations.xhtml).
        method (LinkHTTPMethod): The HTTP method required to make the related
            call.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "href": 'href',
        "rel": 'rel',
        "method": 'method'
    }

    _optionals = [
        'method',
    ]

    def __init__(self,
                 href=None,
                 rel=None,
                 method=APIHelper.SKIP):
        """Constructor for the LinkDescription class"""

        # Initialize members of the class
        self.href = href 
        self.rel = rel 
        if method is not APIHelper.SKIP:
            self.method = method 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        href = dictionary.get("href") if dictionary.get("href") else None
        rel = dictionary.get("rel") if dictionary.get("rel") else None
        method = dictionary.get("method") if dictionary.get("method") else APIHelper.SKIP
        # Return an object of this model
        return cls(href,
                   rel,
                   method)
