# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money
from paypalserversdk.models.universal_product_code import UniversalProductCode


class LineItem(object):

    """Implementation of the 'Line Item' model.

    The line items for this purchase. If your merchant account has been
    configured for Level 3 processing this field will be passed to the
    processor on your behalf.

    Attributes:
        name (str): The item name or title.
        quantity (str): The item quantity. Must be a whole number.
        description (str): The detailed item description.
        sku (str): The stock keeping unit (SKU) for the item.
        url (str): The URL to the item being purchased. Visible to buyer and
            used in buyer experiences.
        image_url (str): The URL of the item's image. File type and size
            restrictions apply. An image that violates these restrictions will
            not be honored.
        upc (UniversalProductCode): The Universal Product Code of the item.
        unit_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        tax (Money): The currency and amount for a financial transaction, such
            as a balance or payment due.
        commodity_code (str): Code used to classify items purchased and track
            the total amount spent across various categories of products and
            services. Different corporate purchasing organizations may use
            different standards, but the United Nations Standard Products and
            Services Code (UNSPSC) is frequently used.
        discount_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        total_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        unit_of_measure (str): Unit of measure is a standard used to express
            the magnitude of a quantity in international trade. Most commonly
            used (but not limited to) examples are: Acre (ACR), Ampere (AMP),
            Centigram (CGM), Centimetre (CMT), Cubic inch (INQ), Cubic metre
            (MTQ), Fluid ounce (OZA), Foot (FOT), Hour (HUR), Item (ITM),
            Kilogram (KGM), Kilometre (KMT), Kilowatt (KWT), Liquid gallon
            (GLL), Liter (LTR), Pounds (LBS), Square foot (FTK).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "quantity": 'quantity',
        "description": 'description',
        "sku": 'sku',
        "url": 'url',
        "image_url": 'image_url',
        "upc": 'upc',
        "unit_amount": 'unit_amount',
        "tax": 'tax',
        "commodity_code": 'commodity_code',
        "discount_amount": 'discount_amount',
        "total_amount": 'total_amount',
        "unit_of_measure": 'unit_of_measure'
    }

    _optionals = [
        'description',
        'sku',
        'url',
        'image_url',
        'upc',
        'unit_amount',
        'tax',
        'commodity_code',
        'discount_amount',
        'total_amount',
        'unit_of_measure',
    ]

    def __init__(self,
                 name=None,
                 quantity=None,
                 description=APIHelper.SKIP,
                 sku=APIHelper.SKIP,
                 url=APIHelper.SKIP,
                 image_url=APIHelper.SKIP,
                 upc=APIHelper.SKIP,
                 unit_amount=APIHelper.SKIP,
                 tax=APIHelper.SKIP,
                 commodity_code=APIHelper.SKIP,
                 discount_amount=APIHelper.SKIP,
                 total_amount=APIHelper.SKIP,
                 unit_of_measure=APIHelper.SKIP):
        """Constructor for the LineItem class"""

        # Initialize members of the class
        self.name = name 
        self.quantity = quantity 
        if description is not APIHelper.SKIP:
            self.description = description 
        if sku is not APIHelper.SKIP:
            self.sku = sku 
        if url is not APIHelper.SKIP:
            self.url = url 
        if image_url is not APIHelper.SKIP:
            self.image_url = image_url 
        if upc is not APIHelper.SKIP:
            self.upc = upc 
        if unit_amount is not APIHelper.SKIP:
            self.unit_amount = unit_amount 
        if tax is not APIHelper.SKIP:
            self.tax = tax 
        if commodity_code is not APIHelper.SKIP:
            self.commodity_code = commodity_code 
        if discount_amount is not APIHelper.SKIP:
            self.discount_amount = discount_amount 
        if total_amount is not APIHelper.SKIP:
            self.total_amount = total_amount 
        if unit_of_measure is not APIHelper.SKIP:
            self.unit_of_measure = unit_of_measure 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else None
        quantity = dictionary.get("quantity") if dictionary.get("quantity") else None
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        sku = dictionary.get("sku") if dictionary.get("sku") else APIHelper.SKIP
        url = dictionary.get("url") if dictionary.get("url") else APIHelper.SKIP
        image_url = dictionary.get("image_url") if dictionary.get("image_url") else APIHelper.SKIP
        upc = UniversalProductCode.from_dictionary(dictionary.get('upc')) if 'upc' in dictionary.keys() else APIHelper.SKIP
        unit_amount = Money.from_dictionary(dictionary.get('unit_amount')) if 'unit_amount' in dictionary.keys() else APIHelper.SKIP
        tax = Money.from_dictionary(dictionary.get('tax')) if 'tax' in dictionary.keys() else APIHelper.SKIP
        commodity_code = dictionary.get("commodity_code") if dictionary.get("commodity_code") else APIHelper.SKIP
        discount_amount = Money.from_dictionary(dictionary.get('discount_amount')) if 'discount_amount' in dictionary.keys() else APIHelper.SKIP
        total_amount = Money.from_dictionary(dictionary.get('total_amount')) if 'total_amount' in dictionary.keys() else APIHelper.SKIP
        unit_of_measure = dictionary.get("unit_of_measure") if dictionary.get("unit_of_measure") else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   quantity,
                   description,
                   sku,
                   url,
                   image_url,
                   upc,
                   unit_amount,
                   tax,
                   commodity_code,
                   discount_amount,
                   total_amount,
                   unit_of_measure)
