# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.address import Address
from paypalserversdk.models.line_item import LineItem
from paypalserversdk.models.money import Money


class Level3CardProcessingData(object):

    """Implementation of the 'Level 3 Card Processing Data' model.

    The level 3 card processing data collections, If your merchant account has
    been configured for Level 3 processing this field will be passed to the
    processor on your behalf. Please contact your PayPal Technical Account
    Manager to define level 3 data for your business.

    Attributes:
        shipping_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        duty_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        discount_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        shipping_address (Address): The portable international postal address.
            Maps to
            [AddressValidationMetadata](https://github.com/googlei18n/libaddres
            sinput/wiki/AddressValidationMetadata) and HTML 5.1 [Autofilling
            form controls: the autocomplete
            attribute](https://www.w3.org/TR/html51/sec-forms.html#autofilling-
            form-controls-the-autocomplete-attribute).
        ships_from_postal_code (str): Use this field to specify the postal
            code of the shipping location.
        line_items (List[LineItem]): A list of the items that were purchased
            with this payment. If your merchant account has been configured
            for Level 3 processing this field will be passed to the processor
            on your behalf.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "shipping_amount": 'shipping_amount',
        "duty_amount": 'duty_amount',
        "discount_amount": 'discount_amount',
        "shipping_address": 'shipping_address',
        "ships_from_postal_code": 'ships_from_postal_code',
        "line_items": 'line_items'
    }

    _optionals = [
        'shipping_amount',
        'duty_amount',
        'discount_amount',
        'shipping_address',
        'ships_from_postal_code',
        'line_items',
    ]

    def __init__(self,
                 shipping_amount=APIHelper.SKIP,
                 duty_amount=APIHelper.SKIP,
                 discount_amount=APIHelper.SKIP,
                 shipping_address=APIHelper.SKIP,
                 ships_from_postal_code=APIHelper.SKIP,
                 line_items=APIHelper.SKIP):
        """Constructor for the Level3CardProcessingData class"""

        # Initialize members of the class
        if shipping_amount is not APIHelper.SKIP:
            self.shipping_amount = shipping_amount 
        if duty_amount is not APIHelper.SKIP:
            self.duty_amount = duty_amount 
        if discount_amount is not APIHelper.SKIP:
            self.discount_amount = discount_amount 
        if shipping_address is not APIHelper.SKIP:
            self.shipping_address = shipping_address 
        if ships_from_postal_code is not APIHelper.SKIP:
            self.ships_from_postal_code = ships_from_postal_code 
        if line_items is not APIHelper.SKIP:
            self.line_items = line_items 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        shipping_amount = Money.from_dictionary(dictionary.get('shipping_amount')) if 'shipping_amount' in dictionary.keys() else APIHelper.SKIP
        duty_amount = Money.from_dictionary(dictionary.get('duty_amount')) if 'duty_amount' in dictionary.keys() else APIHelper.SKIP
        discount_amount = Money.from_dictionary(dictionary.get('discount_amount')) if 'discount_amount' in dictionary.keys() else APIHelper.SKIP
        shipping_address = Address.from_dictionary(dictionary.get('shipping_address')) if 'shipping_address' in dictionary.keys() else APIHelper.SKIP
        ships_from_postal_code = dictionary.get("ships_from_postal_code") if dictionary.get("ships_from_postal_code") else APIHelper.SKIP
        line_items = None
        if dictionary.get('line_items') is not None:
            line_items = [LineItem.from_dictionary(x) for x in dictionary.get('line_items')]
        else:
            line_items = APIHelper.SKIP
        # Return an object of this model
        return cls(shipping_amount,
                   duty_amount,
                   discount_amount,
                   shipping_address,
                   ships_from_postal_code,
                   line_items)
