# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money


class Level2CardProcessingData(object):

    """Implementation of the 'Level 2 Card Processing Data' model.

    The level 2 card processing data collections. If your merchant account has
    been configured for Level 2 processing this field will be passed to the
    processor on your behalf. Please contact your PayPal Technical Account
    Manager to define level 2 data for your business.

    Attributes:
        invoice_id (str): Use this field to pass a purchase identification
            value of up to 127 ASCII characters. The length of this field will
            be adjusted to meet network specifications (25chars for Visa and
            Mastercard, 17chars for Amex), and the original invoice ID will
            still be displayed in your existing reports.
        tax_total (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "invoice_id": 'invoice_id',
        "tax_total": 'tax_total'
    }

    _optionals = [
        'invoice_id',
        'tax_total',
    ]

    def __init__(self,
                 invoice_id=APIHelper.SKIP,
                 tax_total=APIHelper.SKIP):
        """Constructor for the Level2CardProcessingData class"""

        # Initialize members of the class
        if invoice_id is not APIHelper.SKIP:
            self.invoice_id = invoice_id 
        if tax_total is not APIHelper.SKIP:
            self.tax_total = tax_total 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        invoice_id = dictionary.get("invoice_id") if dictionary.get("invoice_id") else APIHelper.SKIP
        tax_total = Money.from_dictionary(dictionary.get('tax_total')) if 'tax_total' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(invoice_id,
                   tax_total)
