# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money
from paypalserversdk.models.universal_product_code import UniversalProductCode


class Item(object):

    """Implementation of the 'Item' model.

    The details for the items to be purchased.

    Attributes:
        name (str): The item name or title.
        unit_amount (Money): The currency and amount for a financial
            transaction, such as a balance or payment due.
        tax (Money): The currency and amount for a financial transaction, such
            as a balance or payment due.
        quantity (str): The item quantity. Must be a whole number.
        description (str): The detailed item description.
        sku (str): The stock keeping unit (SKU) for the item.
        url (str): The URL to the item being purchased. Visible to buyer and
            used in buyer experiences.
        category (ItemCategory): The item category type.
        image_url (str): The URL of the item's image. File type and size
            restrictions apply. An image that violates these restrictions will
            not be honored.
        upc (UniversalProductCode): The Universal Product Code of the item.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "unit_amount": 'unit_amount',
        "quantity": 'quantity',
        "tax": 'tax',
        "description": 'description',
        "sku": 'sku',
        "url": 'url',
        "category": 'category',
        "image_url": 'image_url',
        "upc": 'upc'
    }

    _optionals = [
        'tax',
        'description',
        'sku',
        'url',
        'category',
        'image_url',
        'upc',
    ]

    def __init__(self,
                 name=None,
                 unit_amount=None,
                 quantity=None,
                 tax=APIHelper.SKIP,
                 description=APIHelper.SKIP,
                 sku=APIHelper.SKIP,
                 url=APIHelper.SKIP,
                 category=APIHelper.SKIP,
                 image_url=APIHelper.SKIP,
                 upc=APIHelper.SKIP):
        """Constructor for the Item class"""

        # Initialize members of the class
        self.name = name 
        self.unit_amount = unit_amount 
        if tax is not APIHelper.SKIP:
            self.tax = tax 
        self.quantity = quantity 
        if description is not APIHelper.SKIP:
            self.description = description 
        if sku is not APIHelper.SKIP:
            self.sku = sku 
        if url is not APIHelper.SKIP:
            self.url = url 
        if category is not APIHelper.SKIP:
            self.category = category 
        if image_url is not APIHelper.SKIP:
            self.image_url = image_url 
        if upc is not APIHelper.SKIP:
            self.upc = upc 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else None
        unit_amount = Money.from_dictionary(dictionary.get('unit_amount')) if dictionary.get('unit_amount') else None
        quantity = dictionary.get("quantity") if dictionary.get("quantity") else None
        tax = Money.from_dictionary(dictionary.get('tax')) if 'tax' in dictionary.keys() else APIHelper.SKIP
        description = dictionary.get("description") if dictionary.get("description") else APIHelper.SKIP
        sku = dictionary.get("sku") if dictionary.get("sku") else APIHelper.SKIP
        url = dictionary.get("url") if dictionary.get("url") else APIHelper.SKIP
        category = dictionary.get("category") if dictionary.get("category") else APIHelper.SKIP
        image_url = dictionary.get("image_url") if dictionary.get("image_url") else APIHelper.SKIP
        upc = UniversalProductCode.from_dictionary(dictionary.get('upc')) if 'upc' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   unit_amount,
                   quantity,
                   tax,
                   description,
                   sku,
                   url,
                   category,
                   image_url,
                   upc)
