# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.google_pay_card_response import GooglePayCardResponse
from paypalserversdk.models.phone_number_with_country_code import PhoneNumberWithCountryCode


class GooglePayWalletResponse(object):

    """Implementation of the 'Google Pay Wallet Response' model.

    Google Pay Wallet payment data.

    Attributes:
        name (str): The full name representation like Mr J Smith.
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        phone_number (PhoneNumberWithCountryCode): The phone number in its
            canonical international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).
        card (GooglePayCardResponse): The payment card to use to fund a Google
            Pay payment response. Can be a credit or debit card.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "email_address": 'email_address',
        "phone_number": 'phone_number',
        "card": 'card'
    }

    _optionals = [
        'name',
        'email_address',
        'phone_number',
        'card',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 email_address=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP,
                 card=APIHelper.SKIP):
        """Constructor for the GooglePayWalletResponse class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 
        if card is not APIHelper.SKIP:
            self.card = card 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        phone_number = PhoneNumberWithCountryCode.from_dictionary(dictionary.get('phone_number')) if 'phone_number' in dictionary.keys() else APIHelper.SKIP
        card = GooglePayCardResponse.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   email_address,
                   phone_number,
                   card)
