# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class GooglePayDecryptedTokenData(object):

    """Implementation of the 'Google Pay Decrypted Token Data' model.

    Details shared by Google for the merchant to be shared with PayPal. This
    is required to process the transaction using the Google Pay payment
    method.

    Attributes:
        message_id (str): A unique ID that identifies the message in case it
            needs to be revoked or located at a later time.
        message_expiration (str): Date and time at which the message expires
            as UTC milliseconds since epoch. Integrators should reject any
            message that's expired.
        payment_method (GooglePayPaymentMethod): The type of the payment
            credential. Currently, only CARD is supported.
        authentication_method (GooglePayAuthenticationMethod): Authentication
            Method which is used for the card transaction.
        cryptogram (str): Base-64 cryptographic identifier used by card
            schemes to validate the token verification result. This is a
            conditionally required field if authentication_method is
            CRYPTOGRAM_3DS.
        eci_indicator (str): Electronic Commerce Indicator may not always be
            present. It is only returned for tokens on the Visa card network.
            This value is passed through in the payment authorization
            request.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_method": 'payment_method',
        "authentication_method": 'authentication_method',
        "message_id": 'message_id',
        "message_expiration": 'message_expiration',
        "cryptogram": 'cryptogram',
        "eci_indicator": 'eci_indicator'
    }

    _optionals = [
        'message_id',
        'message_expiration',
        'cryptogram',
        'eci_indicator',
    ]

    def __init__(self,
                 payment_method=None,
                 authentication_method=None,
                 message_id=APIHelper.SKIP,
                 message_expiration=APIHelper.SKIP,
                 cryptogram=APIHelper.SKIP,
                 eci_indicator=APIHelper.SKIP):
        """Constructor for the GooglePayDecryptedTokenData class"""

        # Initialize members of the class
        if message_id is not APIHelper.SKIP:
            self.message_id = message_id 
        if message_expiration is not APIHelper.SKIP:
            self.message_expiration = message_expiration 
        self.payment_method = payment_method 
        self.authentication_method = authentication_method 
        if cryptogram is not APIHelper.SKIP:
            self.cryptogram = cryptogram 
        if eci_indicator is not APIHelper.SKIP:
            self.eci_indicator = eci_indicator 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_method = dictionary.get("payment_method") if dictionary.get("payment_method") else None
        authentication_method = dictionary.get("authentication_method") if dictionary.get("authentication_method") else None
        message_id = dictionary.get("message_id") if dictionary.get("message_id") else APIHelper.SKIP
        message_expiration = dictionary.get("message_expiration") if dictionary.get("message_expiration") else APIHelper.SKIP
        cryptogram = dictionary.get("cryptogram") if dictionary.get("cryptogram") else APIHelper.SKIP
        eci_indicator = dictionary.get("eci_indicator") if dictionary.get("eci_indicator") else APIHelper.SKIP
        # Return an object of this model
        return cls(payment_method,
                   authentication_method,
                   message_id,
                   message_expiration,
                   cryptogram,
                   eci_indicator)
