# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.card_verification import CardVerification


class GooglePayCardAttributes(object):

    """Implementation of the 'Google Pay Card Attributes' model.

    Additional attributes associated with the use of this card.

    Attributes:
        verification (CardVerification): The API caller can opt in to verify
            the card through PayPal offered verification services (e.g. Smart
            Dollar Auth, 3DS).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "verification": 'verification'
    }

    _optionals = [
        'verification',
    ]

    def __init__(self,
                 verification=APIHelper.SKIP):
        """Constructor for the GooglePayCardAttributes class"""

        # Initialize members of the class
        if verification is not APIHelper.SKIP:
            self.verification = verification 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        verification = CardVerification.from_dictionary(dictionary.get('verification')) if 'verification' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(verification)
