# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class ExchangeRate(object):

    """Implementation of the 'Exchange Rate' model.

    The exchange rate that determines the amount to convert from one currency
    to another currency.

    Attributes:
        source_currency (str): The [three-character ISO-4217 currency
            code](/api/rest/reference/currency-codes/) that identifies the
            currency.
        target_currency (str): The [three-character ISO-4217 currency
            code](/api/rest/reference/currency-codes/) that identifies the
            currency.
        value (str): The target currency amount. Equivalent to one unit of the
            source currency. Formatted as integer or decimal value with one to
            15 digits to the right of the decimal point.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "source_currency": 'source_currency',
        "target_currency": 'target_currency',
        "value": 'value'
    }

    _optionals = [
        'source_currency',
        'target_currency',
        'value',
    ]

    def __init__(self,
                 source_currency=APIHelper.SKIP,
                 target_currency=APIHelper.SKIP,
                 value=APIHelper.SKIP):
        """Constructor for the ExchangeRate class"""

        # Initialize members of the class
        if source_currency is not APIHelper.SKIP:
            self.source_currency = source_currency 
        if target_currency is not APIHelper.SKIP:
            self.target_currency = target_currency 
        if value is not APIHelper.SKIP:
            self.value = value 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        source_currency = dictionary.get("source_currency") if dictionary.get("source_currency") else APIHelper.SKIP
        target_currency = dictionary.get("target_currency") if dictionary.get("target_currency") else APIHelper.SKIP
        value = dictionary.get("value") if dictionary.get("value") else APIHelper.SKIP
        # Return an object of this model
        return cls(source_currency,
                   target_currency,
                   value)
