# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.phone_with_type import PhoneWithType


class CustomerInformation(object):

    """Implementation of the 'Customer Information' model.

    The details about a customer in PayPal's system of record.

    Attributes:
        id (str): The unique ID for a customer generated by PayPal.
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        phone (PhoneWithType): The phone information.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "email_address": 'email_address',
        "phone": 'phone'
    }

    _optionals = [
        'id',
        'email_address',
        'phone',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 email_address=APIHelper.SKIP,
                 phone=APIHelper.SKIP):
        """Constructor for the CustomerInformation class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if phone is not APIHelper.SKIP:
            self.phone = phone 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        phone = PhoneWithType.from_dictionary(dictionary.get('phone')) if 'phone' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   email_address,
                   phone)
