# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.order_confirm_application_context import OrderConfirmApplicationContext
from paypalserversdk.models.payment_source import PaymentSource


class ConfirmOrderRequest(object):

    """Implementation of the 'Confirm Order Request' model.

    Payer confirms the intent to pay for the Order using the provided payment
    source.

    Attributes:
        payment_source (PaymentSource): The payment source definition.
        processing_instruction (ProcessingInstruction): The instruction to
            process an order.
        application_context (OrderConfirmApplicationContext): Customizes the
            payer confirmation experience.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "payment_source": 'payment_source',
        "processing_instruction": 'processing_instruction',
        "application_context": 'application_context'
    }

    _optionals = [
        'processing_instruction',
        'application_context',
    ]

    def __init__(self,
                 payment_source=None,
                 processing_instruction='NO_INSTRUCTION',
                 application_context=APIHelper.SKIP):
        """Constructor for the ConfirmOrderRequest class"""

        # Initialize members of the class
        self.payment_source = payment_source 
        self.processing_instruction = processing_instruction 
        if application_context is not APIHelper.SKIP:
            self.application_context = application_context 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        payment_source = PaymentSource.from_dictionary(dictionary.get('payment_source')) if dictionary.get('payment_source') else None
        processing_instruction = dictionary.get("processing_instruction") if dictionary.get("processing_instruction") else 'NO_INSTRUCTION'
        application_context = OrderConfirmApplicationContext.from_dictionary(dictionary.get('application_context')) if 'application_context' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(payment_source,
                   processing_instruction,
                   application_context)
