# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.money import Money
from paypalserversdk.models.payee_base import PayeeBase


class CobrandedCard(object):

    """Implementation of the 'Cobranded Card' model.

    Details about the merchant cobranded card used for order purchase.

    Attributes:
        labels (List[str]): Array of labels for the cobranded card.
        payee (PayeeBase): The details for the merchant who receives the funds
            and fulfills the order. The merchant is also known as the payee.
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "labels": 'labels',
        "payee": 'payee',
        "amount": 'amount'
    }

    _optionals = [
        'labels',
        'payee',
        'amount',
    ]

    def __init__(self,
                 labels=APIHelper.SKIP,
                 payee=APIHelper.SKIP,
                 amount=APIHelper.SKIP):
        """Constructor for the CobrandedCard class"""

        # Initialize members of the class
        if labels is not APIHelper.SKIP:
            self.labels = labels 
        if payee is not APIHelper.SKIP:
            self.payee = payee 
        if amount is not APIHelper.SKIP:
            self.amount = amount 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        labels = dictionary.get("labels") if dictionary.get("labels") else APIHelper.SKIP
        payee = PayeeBase.from_dictionary(dictionary.get('payee')) if 'payee' in dictionary.keys() else APIHelper.SKIP
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(labels,
                   payee,
                   amount)
