# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.card_verification_processor_response import CardVerificationProcessorResponse
from paypalserversdk.models.money import Money


class CardVerificationDetails(object):

    """Implementation of the 'Card Verification Details' model.

    Card Verification details including the authorization details and 3D
    SECURE details.

    Attributes:
        network_transaction_id (str): Transaction Identifier as given by the
            network to indicate a previously executed CIT authorization. Only
            present when authorization is successful for a verification.
        date (str): The date that the transaction was authorized by the
            scheme. This field may not be returned for all networks.
            MasterCard refers to this field as "BankNet reference date".
        network (CardBrand): The card network or brand. Applies to credit,
            debit, gift, and payment cards.
        time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        processor_response (CardVerificationProcessorResponse): The processor
            response information for payment requests, such as direct credit
            card transactions.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "network_transaction_id": 'network_transaction_id',
        "date": 'date',
        "network": 'network',
        "time": 'time',
        "amount": 'amount',
        "processor_response": 'processor_response'
    }

    _optionals = [
        'network_transaction_id',
        'date',
        'network',
        'time',
        'amount',
        'processor_response',
    ]

    def __init__(self,
                 network_transaction_id=APIHelper.SKIP,
                 date=APIHelper.SKIP,
                 network=APIHelper.SKIP,
                 time=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 processor_response=APIHelper.SKIP):
        """Constructor for the CardVerificationDetails class"""

        # Initialize members of the class
        if network_transaction_id is not APIHelper.SKIP:
            self.network_transaction_id = network_transaction_id 
        if date is not APIHelper.SKIP:
            self.date = date 
        if network is not APIHelper.SKIP:
            self.network = network 
        if time is not APIHelper.SKIP:
            self.time = time 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if processor_response is not APIHelper.SKIP:
            self.processor_response = processor_response 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        network_transaction_id = dictionary.get("network_transaction_id") if dictionary.get("network_transaction_id") else APIHelper.SKIP
        date = dictionary.get("date") if dictionary.get("date") else APIHelper.SKIP
        network = dictionary.get("network") if dictionary.get("network") else APIHelper.SKIP
        time = dictionary.get("time") if dictionary.get("time") else APIHelper.SKIP
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        processor_response = CardVerificationProcessorResponse.from_dictionary(dictionary.get('processor_response')) if 'processor_response' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(network_transaction_id,
                   date,
                   network,
                   time,
                   amount,
                   processor_response)
