# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.level_2_card_processing_data import Level2CardProcessingData
from paypalserversdk.models.level_3_card_processing_data import Level3CardProcessingData


class CardSupplementaryData(object):

    """Implementation of the 'Card Supplementary Data' model.

    Merchants and partners can add Level 2 and 3 data to payments to reduce
    risk and payment processing costs. For more information about processing
    payments, see <a
    href="https://developer.paypal.com/docs/checkout/advanced/processing/">chec
    kout</a> or <a
    href="https://developer.paypal.com/docs/multiparty/checkout/advanced/proces
    sing/">multiparty checkout</a>.

    Attributes:
        level_2 (Level2CardProcessingData): The level 2 card processing data
            collections. If your merchant account has been configured for
            Level 2 processing this field will be passed to the processor on
            your behalf. Please contact your PayPal Technical Account Manager
            to define level 2 data for your business.
        level_3 (Level3CardProcessingData): The level 3 card processing data
            collections, If your merchant account has been configured for
            Level 3 processing this field will be passed to the processor on
            your behalf. Please contact your PayPal Technical Account Manager
            to define level 3 data for your business.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "level_2": 'level_2',
        "level_3": 'level_3'
    }

    _optionals = [
        'level_2',
        'level_3',
    ]

    def __init__(self,
                 level_2=APIHelper.SKIP,
                 level_3=APIHelper.SKIP):
        """Constructor for the CardSupplementaryData class"""

        # Initialize members of the class
        if level_2 is not APIHelper.SKIP:
            self.level_2 = level_2 
        if level_3 is not APIHelper.SKIP:
            self.level_3 = level_3 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        level_2 = Level2CardProcessingData.from_dictionary(dictionary.get('level_2')) if 'level_2' in dictionary.keys() else APIHelper.SKIP
        level_3 = Level3CardProcessingData.from_dictionary(dictionary.get('level_3')) if 'level_3' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(level_2,
                   level_3)
