# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class CardFromRequest(object):

    """Implementation of the 'Card From Request' model.

    Representation of card details as received in the request.

    Attributes:
        expiry (str): The year and month, in ISO-8601 `YYYY-MM` date format.
            See [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6).
        last_digits (str): The last digits of the payment card.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "expiry": 'expiry',
        "last_digits": 'last_digits'
    }

    _optionals = [
        'expiry',
        'last_digits',
    ]

    def __init__(self,
                 expiry=APIHelper.SKIP,
                 last_digits=APIHelper.SKIP):
        """Constructor for the CardFromRequest class"""

        # Initialize members of the class
        if expiry is not APIHelper.SKIP:
            self.expiry = expiry 
        if last_digits is not APIHelper.SKIP:
            self.last_digits = last_digits 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        expiry = dictionary.get("expiry") if dictionary.get("expiry") else APIHelper.SKIP
        last_digits = dictionary.get("last_digits") if dictionary.get("last_digits") else APIHelper.SKIP
        # Return an object of this model
        return cls(expiry,
                   last_digits)
