# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.card_customer_information import CardCustomerInformation
from paypalserversdk.models.card_verification import CardVerification
from paypalserversdk.models.vault_instruction_base import VaultInstructionBase


class CardAttributes(object):

    """Implementation of the 'Card Attributes' model.

    Additional attributes associated with the use of this card.

    Attributes:
        customer (CardCustomerInformation): The details about a customer in
            PayPal's system of record.
        vault (VaultInstructionBase): Basic vault instruction specification
            that can be extended by specific payment sources that supports
            vaulting.
        verification (CardVerification): The API caller can opt in to verify
            the card through PayPal offered verification services (e.g. Smart
            Dollar Auth, 3DS).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "customer": 'customer',
        "vault": 'vault',
        "verification": 'verification'
    }

    _optionals = [
        'customer',
        'vault',
        'verification',
    ]

    def __init__(self,
                 customer=APIHelper.SKIP,
                 vault=APIHelper.SKIP,
                 verification=APIHelper.SKIP):
        """Constructor for the CardAttributes class"""

        # Initialize members of the class
        if customer is not APIHelper.SKIP:
            self.customer = customer 
        if vault is not APIHelper.SKIP:
            self.vault = vault 
        if verification is not APIHelper.SKIP:
            self.verification = verification 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        customer = CardCustomerInformation.from_dictionary(dictionary.get('customer')) if 'customer' in dictionary.keys() else APIHelper.SKIP
        vault = VaultInstructionBase.from_dictionary(dictionary.get('vault')) if 'vault' in dictionary.keys() else APIHelper.SKIP
        verification = CardVerification.from_dictionary(dictionary.get('verification')) if 'verification' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(customer,
                   vault,
                   verification)
