# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.blik_one_click_payment_object import BLIKOneClickPaymentObject


class BLIKPaymentObject(object):

    """Implementation of the 'BLIK Payment Object' model.

    Information used to pay using BLIK.

    Attributes:
        name (str): The full name representation like Mr J Smith.
        country_code (str): The [two-character ISO 3166-1
            code](/api/rest/reference/country-codes/) that identifies the
            country or region.<blockquote><strong>Note:</strong> The country
            code for Great Britain is <code>GB</code> and not <code>UK</code>
            as used in the top-level domain names for that country. Use the
            `C2` country code for China worldwide for comparable uncontrolled
            price (CUP) method, bank card, and cross-border
            transactions.</blockquote>
        email (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        one_click (BLIKOneClickPaymentObject): Information used to pay using
            BLIK one-click flow.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "name": 'name',
        "country_code": 'country_code',
        "email": 'email',
        "one_click": 'one_click'
    }

    _optionals = [
        'name',
        'country_code',
        'email',
        'one_click',
    ]

    def __init__(self,
                 name=APIHelper.SKIP,
                 country_code=APIHelper.SKIP,
                 email=APIHelper.SKIP,
                 one_click=APIHelper.SKIP):
        """Constructor for the BLIKPaymentObject class"""

        # Initialize members of the class
        if name is not APIHelper.SKIP:
            self.name = name 
        if country_code is not APIHelper.SKIP:
            self.country_code = country_code 
        if email is not APIHelper.SKIP:
            self.email = email 
        if one_click is not APIHelper.SKIP:
            self.one_click = one_click 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        country_code = dictionary.get("country_code") if dictionary.get("country_code") else APIHelper.SKIP
        email = dictionary.get("email") if dictionary.get("email") else APIHelper.SKIP
        one_click = BLIKOneClickPaymentObject.from_dictionary(dictionary.get('one_click')) if 'one_click' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(name,
                   country_code,
                   email,
                   one_click)
