# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class BLIKOneClickPaymentRequest(object):

    """Implementation of the 'BLIK One-Click Payment Request' model.

    Information used to pay using BLIK one-click flow.

    Attributes:
        auth_code (str): The 6-digit code used to authenticate a consumer
            within BLIK.
        consumer_reference (str): The merchant generated, unique reference
            serving as a primary identifier for accounts connected between
            Blik and a merchant.
        alias_label (str): A bank defined identifier used as a display name to
            allow the payer to differentiate between multiple registered bank
            accounts.
        alias_key (str): A Blik-defined identifier for a specific Blik-enabled
            bank account that is associated with a given merchant. Used only
            in conjunction with a Consumer Reference.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "consumer_reference": 'consumer_reference',
        "auth_code": 'auth_code',
        "alias_label": 'alias_label',
        "alias_key": 'alias_key'
    }

    _optionals = [
        'auth_code',
        'alias_label',
        'alias_key',
    ]

    def __init__(self,
                 consumer_reference=None,
                 auth_code=APIHelper.SKIP,
                 alias_label=APIHelper.SKIP,
                 alias_key=APIHelper.SKIP):
        """Constructor for the BLIKOneClickPaymentRequest class"""

        # Initialize members of the class
        if auth_code is not APIHelper.SKIP:
            self.auth_code = auth_code 
        self.consumer_reference = consumer_reference 
        if alias_label is not APIHelper.SKIP:
            self.alias_label = alias_label 
        if alias_key is not APIHelper.SKIP:
            self.alias_key = alias_key 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        consumer_reference = dictionary.get("consumer_reference") if dictionary.get("consumer_reference") else None
        auth_code = dictionary.get("auth_code") if dictionary.get("auth_code") else APIHelper.SKIP
        alias_label = dictionary.get("alias_label") if dictionary.get("alias_label") else APIHelper.SKIP
        alias_key = dictionary.get("alias_key") if dictionary.get("alias_key") else APIHelper.SKIP
        # Return an object of this model
        return cls(consumer_reference,
                   auth_code,
                   alias_label,
                   alias_key)
