# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class BLIKOneClickPaymentObject(object):

    """Implementation of the 'BLIK One-Click Payment Object' model.

    Information used to pay using BLIK one-click flow.

    Attributes:
        consumer_reference (str): The merchant generated, unique reference
            serving as a primary identifier for accounts connected between
            Blik and a merchant.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "consumer_reference": 'consumer_reference'
    }

    _optionals = [
        'consumer_reference',
    ]

    def __init__(self,
                 consumer_reference=APIHelper.SKIP):
        """Constructor for the BLIKOneClickPaymentObject class"""

        # Initialize members of the class
        if consumer_reference is not APIHelper.SKIP:
            self.consumer_reference = consumer_reference 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        consumer_reference = dictionary.get("consumer_reference") if dictionary.get("consumer_reference") else APIHelper.SKIP
        # Return an object of this model
        return cls(consumer_reference)
