# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class BLIKExperienceContext(object):

    """Implementation of the 'BLIK Experience Context' model.

    Customizes the payer experience during the approval process for the BLIK
    payment.

    Attributes:
        brand_name (str): The label that overrides the business name in the
            PayPal account on the PayPal site. The pattern is defined by an
            external party and supports Unicode.
        locale (str): The [language
            tag](https://tools.ietf.org/html/bcp47#section-2) for the language
            in which to localize the error-related strings, such as messages,
            issues, and suggested actions. The tag is made up of the [ISO
            639-2 language
            code](https://www.loc.gov/standards/iso639-2/php/code_list.php),
            the optional [ISO-15924 script
            tag](https://www.unicode.org/iso15924/codelists.html), and the
            [ISO-3166 alpha-2 country
            code](/api/rest/reference/country-codes/) or [M49 region
            code](https://unstats.un.org/unsd/methodology/m49/).
        shipping_preference (ShippingPreference): The location from which the
            shipping address is derived.
        return_url (str): Describes the URL.
        cancel_url (str): Describes the URL.
        consumer_ip (str): An Internet Protocol address (IP address). This
            address assigns a numerical label to each device that is connected
            to a computer network through the Internet Protocol. Supports IPv4
            and IPv6 addresses.
        consumer_user_agent (str): The payer's User Agent. For example,
            Mozilla/5.0 (Macintosh; Intel Mac OS X x.y; rv:42.0).

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "brand_name": 'brand_name',
        "locale": 'locale',
        "shipping_preference": 'shipping_preference',
        "return_url": 'return_url',
        "cancel_url": 'cancel_url',
        "consumer_ip": 'consumer_ip',
        "consumer_user_agent": 'consumer_user_agent'
    }

    _optionals = [
        'brand_name',
        'locale',
        'shipping_preference',
        'return_url',
        'cancel_url',
        'consumer_ip',
        'consumer_user_agent',
    ]

    def __init__(self,
                 brand_name=APIHelper.SKIP,
                 locale=APIHelper.SKIP,
                 shipping_preference='GET_FROM_FILE',
                 return_url=APIHelper.SKIP,
                 cancel_url=APIHelper.SKIP,
                 consumer_ip=APIHelper.SKIP,
                 consumer_user_agent=APIHelper.SKIP):
        """Constructor for the BLIKExperienceContext class"""

        # Initialize members of the class
        if brand_name is not APIHelper.SKIP:
            self.brand_name = brand_name 
        if locale is not APIHelper.SKIP:
            self.locale = locale 
        self.shipping_preference = shipping_preference 
        if return_url is not APIHelper.SKIP:
            self.return_url = return_url 
        if cancel_url is not APIHelper.SKIP:
            self.cancel_url = cancel_url 
        if consumer_ip is not APIHelper.SKIP:
            self.consumer_ip = consumer_ip 
        if consumer_user_agent is not APIHelper.SKIP:
            self.consumer_user_agent = consumer_user_agent 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        brand_name = dictionary.get("brand_name") if dictionary.get("brand_name") else APIHelper.SKIP
        locale = dictionary.get("locale") if dictionary.get("locale") else APIHelper.SKIP
        shipping_preference = dictionary.get("shipping_preference") if dictionary.get("shipping_preference") else 'GET_FROM_FILE'
        return_url = dictionary.get("return_url") if dictionary.get("return_url") else APIHelper.SKIP
        cancel_url = dictionary.get("cancel_url") if dictionary.get("cancel_url") else APIHelper.SKIP
        consumer_ip = dictionary.get("consumer_ip") if dictionary.get("consumer_ip") else APIHelper.SKIP
        consumer_user_agent = dictionary.get("consumer_user_agent") if dictionary.get("consumer_user_agent") else APIHelper.SKIP
        # Return an object of this model
        return cls(brand_name,
                   locale,
                   shipping_preference,
                   return_url,
                   cancel_url,
                   consumer_ip,
                   consumer_user_agent)
