# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.authorization_status_details import AuthorizationStatusDetails
from paypalserversdk.models.link_description import LinkDescription
from paypalserversdk.models.money import Money
from paypalserversdk.models.network_transaction_reference import NetworkTransactionReference
from paypalserversdk.models.processor_response import ProcessorResponse
from paypalserversdk.models.seller_protection import SellerProtection


class AuthorizationWithAdditionalData(object):

    """Implementation of the 'Authorization With Additional Data' model.

    The authorization with additional payment details, such as risk assessment
    and processor response. These details are populated only for certain
    payment methods.

    Attributes:
        status (AuthorizationStatus): The status for the authorized payment.
        status_details (AuthorizationStatusDetails): The details of the
            authorized payment status.
        id (str): The PayPal-generated ID for the authorized payment.
        amount (Money): The currency and amount for a financial transaction,
            such as a balance or payment due.
        invoice_id (str): The API caller-provided external invoice number for
            this order. Appears in both the payer's transaction history and
            the emails that the payer receives.
        custom_id (str): The API caller-provided external ID. Used to
            reconcile API caller-initiated transactions with PayPal
            transactions. Appears in transaction and settlement reports.
        network_transaction_reference (NetworkTransactionReference): Reference
            values used by the card network to identify a transaction.
        seller_protection (SellerProtection): The level of protection offered
            as defined by [PayPal Seller Protection for
            Merchants](https://www.paypal.com/us/webapps/mpp/security/seller-pr
            otection).
        expiration_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        links (List[LinkDescription]): An array of related [HATEOAS
            links](/docs/api/reference/api-responses/#hateoas-links).
        create_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        update_time (str): The date and time, in [Internet date and time
            format](https://tools.ietf.org/html/rfc3339#section-5.6). Seconds
            are required while fractional seconds are
            optional.<blockquote><strong>Note:</strong> The regular expression
            provides guidance but does not reject all invalid
            dates.</blockquote>
        processor_response (ProcessorResponse): The processor response
            information for payment requests, such as direct credit card
            transactions.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "status": 'status',
        "status_details": 'status_details',
        "id": 'id',
        "amount": 'amount',
        "invoice_id": 'invoice_id',
        "custom_id": 'custom_id',
        "network_transaction_reference": 'network_transaction_reference',
        "seller_protection": 'seller_protection',
        "expiration_time": 'expiration_time',
        "links": 'links',
        "create_time": 'create_time',
        "update_time": 'update_time',
        "processor_response": 'processor_response'
    }

    _optionals = [
        'status',
        'status_details',
        'id',
        'amount',
        'invoice_id',
        'custom_id',
        'network_transaction_reference',
        'seller_protection',
        'expiration_time',
        'links',
        'create_time',
        'update_time',
        'processor_response',
    ]

    def __init__(self,
                 status=APIHelper.SKIP,
                 status_details=APIHelper.SKIP,
                 id=APIHelper.SKIP,
                 amount=APIHelper.SKIP,
                 invoice_id=APIHelper.SKIP,
                 custom_id=APIHelper.SKIP,
                 network_transaction_reference=APIHelper.SKIP,
                 seller_protection=APIHelper.SKIP,
                 expiration_time=APIHelper.SKIP,
                 links=APIHelper.SKIP,
                 create_time=APIHelper.SKIP,
                 update_time=APIHelper.SKIP,
                 processor_response=APIHelper.SKIP):
        """Constructor for the AuthorizationWithAdditionalData class"""

        # Initialize members of the class
        if status is not APIHelper.SKIP:
            self.status = status 
        if status_details is not APIHelper.SKIP:
            self.status_details = status_details 
        if id is not APIHelper.SKIP:
            self.id = id 
        if amount is not APIHelper.SKIP:
            self.amount = amount 
        if invoice_id is not APIHelper.SKIP:
            self.invoice_id = invoice_id 
        if custom_id is not APIHelper.SKIP:
            self.custom_id = custom_id 
        if network_transaction_reference is not APIHelper.SKIP:
            self.network_transaction_reference = network_transaction_reference 
        if seller_protection is not APIHelper.SKIP:
            self.seller_protection = seller_protection 
        if expiration_time is not APIHelper.SKIP:
            self.expiration_time = expiration_time 
        if links is not APIHelper.SKIP:
            self.links = links 
        if create_time is not APIHelper.SKIP:
            self.create_time = create_time 
        if update_time is not APIHelper.SKIP:
            self.update_time = update_time 
        if processor_response is not APIHelper.SKIP:
            self.processor_response = processor_response 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        status = dictionary.get("status") if dictionary.get("status") else APIHelper.SKIP
        status_details = AuthorizationStatusDetails.from_dictionary(dictionary.get('status_details')) if 'status_details' in dictionary.keys() else APIHelper.SKIP
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        amount = Money.from_dictionary(dictionary.get('amount')) if 'amount' in dictionary.keys() else APIHelper.SKIP
        invoice_id = dictionary.get("invoice_id") if dictionary.get("invoice_id") else APIHelper.SKIP
        custom_id = dictionary.get("custom_id") if dictionary.get("custom_id") else APIHelper.SKIP
        network_transaction_reference = NetworkTransactionReference.from_dictionary(dictionary.get('network_transaction_reference')) if 'network_transaction_reference' in dictionary.keys() else APIHelper.SKIP
        seller_protection = SellerProtection.from_dictionary(dictionary.get('seller_protection')) if 'seller_protection' in dictionary.keys() else APIHelper.SKIP
        expiration_time = dictionary.get("expiration_time") if dictionary.get("expiration_time") else APIHelper.SKIP
        links = None
        if dictionary.get('links') is not None:
            links = [LinkDescription.from_dictionary(x) for x in dictionary.get('links')]
        else:
            links = APIHelper.SKIP
        create_time = dictionary.get("create_time") if dictionary.get("create_time") else APIHelper.SKIP
        update_time = dictionary.get("update_time") if dictionary.get("update_time") else APIHelper.SKIP
        processor_response = ProcessorResponse.from_dictionary(dictionary.get('processor_response')) if 'processor_response' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(status,
                   status_details,
                   id,
                   amount,
                   invoice_id,
                   custom_id,
                   network_transaction_reference,
                   seller_protection,
                   expiration_time,
                   links,
                   create_time,
                   update_time,
                   processor_response)
