# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper


class AssuranceDetails(object):

    """Implementation of the 'Assurance Details' model.

    Information about cardholder possession validation and cardholder
    identification and verifications (ID&V).

    Attributes:
        account_verified (bool): If true, indicates that Cardholder possession
            validation has been performed on returned payment credential.
        card_holder_authenticated (bool): If true, indicates that
            identification and verifications (ID&V) was performed on the
            returned payment credential.If false, the same risk-based
            authentication can be performed as you would for card
            transactions. This risk-based authentication can include, but not
            limited to, step-up with 3D Secure protocol if applicable.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "account_verified": 'account_verified',
        "card_holder_authenticated": 'card_holder_authenticated'
    }

    _optionals = [
        'account_verified',
        'card_holder_authenticated',
    ]

    def __init__(self,
                 account_verified=False,
                 card_holder_authenticated=False):
        """Constructor for the AssuranceDetails class"""

        # Initialize members of the class
        self.account_verified = account_verified 
        self.card_holder_authenticated = card_holder_authenticated 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        account_verified = dictionary.get("account_verified") if dictionary.get("account_verified") else False
        card_holder_authenticated = dictionary.get("card_holder_authenticated") if dictionary.get("card_holder_authenticated") else False
        # Return an object of this model
        return cls(account_verified,
                   card_holder_authenticated)
