# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_attributes import ApplePayAttributes
from paypalserversdk.models.apple_pay_decrypted_token_data import ApplePayDecryptedTokenData
from paypalserversdk.models.card_stored_credential import CardStoredCredential
from paypalserversdk.models.phone_number import PhoneNumber


class ApplePayRequest(object):

    """Implementation of the 'Apple Pay Request' model.

    Information needed to pay using ApplePay.

    Attributes:
        id (str): ApplePay transaction identifier, this will be the unique
            identifier for this transaction provided by Apple. The pattern is
            defined by an external party and supports Unicode.
        name (str): The full name representation like Mr J Smith.
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        phone_number (PhoneNumber): The phone number in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).
        decrypted_token (ApplePayDecryptedTokenData): Information about the
            Payment data obtained by decrypting Apple Pay token.
        stored_credential (CardStoredCredential): Provides additional details
            to process a payment using a `card` that has been stored or is
            intended to be stored (also referred to as stored_credential or
            card-on-file).<br/>Parameter
            compatibility:<br/><ul><li>`payment_type=ONE_TIME` is compatible
            only with `payment_initiator=CUSTOMER`.</li><li>`usage=FIRST` is
            compatible only with
            `payment_initiator=CUSTOMER`.</li><li>`previous_transaction_referen
            ce` or `previous_network_transaction_reference` is compatible only
            with `payment_initiator=MERCHANT`.</li><li>Only one of the
            parameters - `previous_transaction_reference` and
            `previous_network_transaction_reference` - can be present in the
            request.</li></ul>
        vault_id (str): The PayPal-generated ID for the vaulted payment
            source. This ID should be stored on the merchant's server so the
            saved payment source can be used for future transactions.
        attributes (ApplePayAttributes): Additional attributes associated with
            apple pay.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "name": 'name',
        "email_address": 'email_address',
        "phone_number": 'phone_number',
        "decrypted_token": 'decrypted_token',
        "stored_credential": 'stored_credential',
        "vault_id": 'vault_id',
        "attributes": 'attributes'
    }

    _optionals = [
        'id',
        'name',
        'email_address',
        'phone_number',
        'decrypted_token',
        'stored_credential',
        'vault_id',
        'attributes',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 email_address=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP,
                 decrypted_token=APIHelper.SKIP,
                 stored_credential=APIHelper.SKIP,
                 vault_id=APIHelper.SKIP,
                 attributes=APIHelper.SKIP):
        """Constructor for the ApplePayRequest class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if name is not APIHelper.SKIP:
            self.name = name 
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 
        if decrypted_token is not APIHelper.SKIP:
            self.decrypted_token = decrypted_token 
        if stored_credential is not APIHelper.SKIP:
            self.stored_credential = stored_credential 
        if vault_id is not APIHelper.SKIP:
            self.vault_id = vault_id 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        phone_number = PhoneNumber.from_dictionary(dictionary.get('phone_number')) if 'phone_number' in dictionary.keys() else APIHelper.SKIP
        decrypted_token = ApplePayDecryptedTokenData.from_dictionary(dictionary.get('decrypted_token')) if 'decrypted_token' in dictionary.keys() else APIHelper.SKIP
        stored_credential = CardStoredCredential.from_dictionary(dictionary.get('stored_credential')) if 'stored_credential' in dictionary.keys() else APIHelper.SKIP
        vault_id = dictionary.get("vault_id") if dictionary.get("vault_id") else APIHelper.SKIP
        attributes = ApplePayAttributes.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   name,
                   email_address,
                   phone_number,
                   decrypted_token,
                   stored_credential,
                   vault_id,
                   attributes)
