# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_card import ApplePayCard


class ApplePayPaymentToken(object):

    """Implementation of the 'Apple Pay Payment Token' model.

    A resource representing a response for Apple Pay.

    Attributes:
        card (ApplePayCard): The payment card to be used to fund a payment.
            Can be a credit or debit card.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "card": 'card'
    }

    _optionals = [
        'card',
    ]

    def __init__(self,
                 card=APIHelper.SKIP):
        """Constructor for the ApplePayPaymentToken class"""

        # Initialize members of the class
        if card is not APIHelper.SKIP:
            self.card = card 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        card = ApplePayCard.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(card)
