# -*- coding: utf-8 -*-

"""
paypalserversdk

This file was automatically generated by APIMATIC v3.0 (
 https://www.apimatic.io ).
"""
from paypalserversdk.api_helper import APIHelper
from paypalserversdk.models.apple_pay_attributes_response import ApplePayAttributesResponse
from paypalserversdk.models.apple_pay_card_response import ApplePayCardResponse
from paypalserversdk.models.phone_number import PhoneNumber


class ApplePayPaymentObject(object):

    """Implementation of the 'Apple Pay Payment Object' model.

    Information needed to pay using ApplePay.

    Attributes:
        id (str): ApplePay transaction identifier, this will be the unique
            identifier for this transaction provided by Apple. The pattern is
            defined by an external party and supports Unicode.
        token (str): Encrypted ApplePay token, containing card information.
            This token would be base64encoded. The pattern is defined by an
            external party and supports Unicode.
        name (str): The full name representation like Mr J Smith.
        email_address (str): The internationalized email
            address.<blockquote><strong>Note:</strong> Up to 64 characters are
            allowed before and 255 characters are allowed after the
            <code>@</code> sign. However, the generally accepted maximum
            length for an email address is 254 characters. The pattern
            verifies that an unquoted <code>@</code> sign
            exists.</blockquote>
        phone_number (PhoneNumber): The phone number in its canonical
            international [E.164 numbering plan
            format](https://www.itu.int/rec/T-REC-E.164/en).
        card (ApplePayCardResponse): The Card from Apple Pay Wallet used to
            fund the payment.
        attributes (ApplePayAttributesResponse): Additional attributes
            associated with the use of Apple Pay.

    """

    # Create a mapping from Model property names to API property names
    _names = {
        "id": 'id',
        "token": 'token',
        "name": 'name',
        "email_address": 'email_address',
        "phone_number": 'phone_number',
        "card": 'card',
        "attributes": 'attributes'
    }

    _optionals = [
        'id',
        'token',
        'name',
        'email_address',
        'phone_number',
        'card',
        'attributes',
    ]

    def __init__(self,
                 id=APIHelper.SKIP,
                 token=APIHelper.SKIP,
                 name=APIHelper.SKIP,
                 email_address=APIHelper.SKIP,
                 phone_number=APIHelper.SKIP,
                 card=APIHelper.SKIP,
                 attributes=APIHelper.SKIP):
        """Constructor for the ApplePayPaymentObject class"""

        # Initialize members of the class
        if id is not APIHelper.SKIP:
            self.id = id 
        if token is not APIHelper.SKIP:
            self.token = token 
        if name is not APIHelper.SKIP:
            self.name = name 
        if email_address is not APIHelper.SKIP:
            self.email_address = email_address 
        if phone_number is not APIHelper.SKIP:
            self.phone_number = phone_number 
        if card is not APIHelper.SKIP:
            self.card = card 
        if attributes is not APIHelper.SKIP:
            self.attributes = attributes 

    @classmethod
    def from_dictionary(cls,
                        dictionary):
        """Creates an instance of this model from a dictionary

        Args:
            dictionary (dictionary): A dictionary representation of the object
            as obtained from the deserialization of the server's response. The
            keys MUST match property names in the API description.

        Returns:
            object: An instance of this structure class.

        """

        if dictionary is None:
            return None

        # Extract variables from the dictionary
        id = dictionary.get("id") if dictionary.get("id") else APIHelper.SKIP
        token = dictionary.get("token") if dictionary.get("token") else APIHelper.SKIP
        name = dictionary.get("name") if dictionary.get("name") else APIHelper.SKIP
        email_address = dictionary.get("email_address") if dictionary.get("email_address") else APIHelper.SKIP
        phone_number = PhoneNumber.from_dictionary(dictionary.get('phone_number')) if 'phone_number' in dictionary.keys() else APIHelper.SKIP
        card = ApplePayCardResponse.from_dictionary(dictionary.get('card')) if 'card' in dictionary.keys() else APIHelper.SKIP
        attributes = ApplePayAttributesResponse.from_dictionary(dictionary.get('attributes')) if 'attributes' in dictionary.keys() else APIHelper.SKIP
        # Return an object of this model
        return cls(id,
                   token,
                   name,
                   email_address,
                   phone_number,
                   card,
                   attributes)
